/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.basicfunctions.AugmentMapFunction;
import com.google.template.soy.basicfunctions.CeilingFunction;
import com.google.template.soy.basicfunctions.FloorFunction;
import com.google.template.soy.basicfunctions.KeysFunction;
import com.google.template.soy.basicfunctions.MaxFunction;
import com.google.template.soy.basicfunctions.MinFunction;
import com.google.template.soy.basicfunctions.RandomIntFunction;
import com.google.template.soy.basicfunctions.RoundFunction;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.SoyExpression;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class PluginFunctionCompiler {
    private static final MethodRef AUGMENT_MAP_FN = MethodRef.create(AugmentMapFunction.class, "augmentMap", SoyDict.class, SoyDict.class).asNonNullable();
    private static final MethodRef CEIL_FN = MethodRef.create(CeilingFunction.class, "ceil", SoyValue.class).asNonNullable();
    private static final MethodRef FLOOR_FN = MethodRef.create(FloorFunction.class, "floor", SoyValue.class).asNonNullable();
    private static final MethodRef KEYS_FN = MethodRef.create(KeysFunction.class, "keys", SoyMap.class);
    private static final MethodRef LIST_SIZE = MethodRef.create(List.class, "size", new Class[0]);
    private static final MethodRef MATH_CEIL = MethodRef.create(Math.class, "ceil", Double.TYPE).asCheap();
    private static final MethodRef MATH_FLOOR = MethodRef.create(Math.class, "floor", Double.TYPE).asCheap();
    private static final MethodRef MATH_MAX_DOUBLE = MethodRef.create(Math.class, "max", Double.TYPE, Double.TYPE).asCheap();
    private static final MethodRef MATH_MAX_LONG = MethodRef.create(Math.class, "max", Long.TYPE, Long.TYPE).asCheap();
    private static final MethodRef MATH_MIN_DOUBLE = MethodRef.create(Math.class, "min", Double.TYPE, Double.TYPE).asCheap();
    private static final MethodRef MATH_MIN_LONG = MethodRef.create(Math.class, "min", Long.TYPE, Long.TYPE).asCheap();
    private static final MethodRef MATH_ROUND = MethodRef.create(Math.class, "round", Double.TYPE).asCheap();
    private static final MethodRef MAX_FN = MethodRef.create(MaxFunction.class, "max", SoyValue.class, SoyValue.class).asNonNullable();
    private static final MethodRef MIN_FN = MethodRef.create(MinFunction.class, "min", SoyValue.class, SoyValue.class).asNonNullable();
    private static final MethodRef RANDOM_INT_FN = MethodRef.create(RandomIntFunction.class, "randomInt", Long.TYPE).asCheap();
    private static final MethodRef ROUND_FN = MethodRef.create(RoundFunction.class, "round", SoyValue.class).asNonNullable();
    private static final MethodRef ROUND_WITH_NUM_DIGITS_AFTER_POINT_FN = MethodRef.create(RoundFunction.class, "round", SoyValue.class, Integer.TYPE).asNonNullable();
    private static final MethodRef SOYLIST_LENGTH = MethodRef.create(SoyList.class, "length", new Class[0]);
    private static final MethodRef STRING_CONTAINS = MethodRef.create(String.class, "contains", CharSequence.class);
    private static final MethodRef STRING_INDEX_OF = MethodRef.create(String.class, "indexOf", String.class);
    private static final MethodRef STRING_LENGTH = MethodRef.create(String.class, "length", new Class[0]);
    private static final MethodRef STRING_SUBSTR_START = MethodRef.create(String.class, "substring", Integer.TYPE).asNonNullable();
    private static final MethodRef STRING_SUBSTR_START_END = MethodRef.create(String.class, "substring", Integer.TYPE, Integer.TYPE);
    private final TemplateParameterLookup parameterLookup;

    PluginFunctionCompiler(TemplateParameterLookup parameterLookup) {
        this.parameterLookup = parameterLookup;
    }

    SoyExpression callPluginFunction(FunctionNode node, List<SoyExpression> args) {
        switch (node.getFunctionName()) {
            case "augmentMap": {
                return this.invokeAugmentMapFunction(args.get(0), args.get(1));
            }
            case "ceiling": {
                return this.invokeCeilingFunction(args.get(0));
            }
            case "floor": {
                return this.invokeFloorFunction(args.get(0));
            }
            case "isNonnull": {
                return this.invokeIsNonnullFunction(args.get(0));
            }
            case "keys": {
                return this.invokeKeysFunction(args.get(0));
            }
            case "length": {
                return this.invokeLengthFunction(args.get(0));
            }
            case "max": {
                return this.invokeMaxFunction(args.get(0), args.get(1));
            }
            case "min": {
                return this.invokeMinFunction(args.get(0), args.get(1));
            }
            case "randomInt": {
                return this.invokeRandomIntFunction(args.get(0));
            }
            case "round": {
                if (args.size() == 1) {
                    return this.invokeRoundFunction(args.get(0));
                }
                return this.invokeRoundFunction(args.get(0), args.get(1));
            }
            case "strContains": {
                return this.invokeStrContainsFunction(args.get(0), args.get(1));
            }
            case "strIndexOf": {
                return this.invokeStrIndexOfFunction(args.get(0), args.get(1));
            }
            case "strLen": {
                return this.invokeStrLenFunction(args.get(0));
            }
            case "strSub": {
                if (args.size() == 2) {
                    return this.invokeStrSubFunction(args.get(0), args.get(1));
                }
                return this.invokeStrSubFunction(args.get(0), args.get(1), args.get(2));
            }
            case "$$float": {
                return this.invokeFloatFunction(args.get(0));
            }
        }
        return this.invokeSoyFunction(node, args);
    }

    private SoyExpression invokeAugmentMapFunction(SoyExpression arg0, SoyExpression arg1) {
        Expression first = arg0.checkedCast(SoyDict.class);
        Expression second = arg1.checkedCast(SoyDict.class);
        MapType mapType = MapType.of(StringType.getInstance(), UnionType.of(this.getMapValueType(arg0.soyType()), this.getMapValueType(arg1.soyType())));
        return SoyExpression.forSoyValue(mapType, AUGMENT_MAP_FN.invoke(first, second));
    }

    private SoyType getMapValueType(SoyType type) {
        if (type.getKind() == SoyType.Kind.MAP) {
            return ((MapType)type).getValueType();
        }
        return UnknownType.getInstance();
    }

    private SoyExpression invokeCeilingFunction(SoyExpression argument) {
        switch (argument.resultType().getSort()) {
            case 7: {
                return argument;
            }
            case 8: {
                return SoyExpression.forInt(BytecodeUtils.numericConversion(MATH_CEIL.invoke(argument), Type.LONG_TYPE));
            }
        }
        return SoyExpression.forSoyValue(IntType.getInstance(), CEIL_FN.invoke(argument.box()));
    }

    private SoyExpression invokeFloatFunction(SoyExpression arg) {
        SoyExpression unboxed = arg.isBoxed() ? arg.unboxAs(Long.TYPE) : arg;
        SoyExpression result = SoyExpression.forFloat(BytecodeUtils.numericConversion(unboxed, Type.DOUBLE_TYPE));
        return arg.isCheap() ? result.asCheap() : result;
    }

    private SoyExpression invokeFloorFunction(SoyExpression argument) {
        switch (argument.resultType().getSort()) {
            case 7: {
                return argument;
            }
            case 8: {
                return SoyExpression.forInt(BytecodeUtils.numericConversion(MATH_FLOOR.invoke(argument), Type.LONG_TYPE));
            }
        }
        return SoyExpression.forSoyValue(IntType.getInstance(), FLOOR_FN.invoke(argument.box()));
    }

    private SoyExpression invokeIsNonnullFunction(final SoyExpression soyExpression) {
        if (BytecodeUtils.isPrimitive(soyExpression.resultType())) {
            return SoyExpression.TRUE;
        }
        return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE, soyExpression.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                soyExpression.gen(adapter);
                Label isNull = new Label();
                adapter.ifNull(isNull);
                adapter.pushBoolean(true);
                Label end = new Label();
                adapter.goTo(end);
                adapter.mark(isNull);
                adapter.pushBoolean(false);
                adapter.mark(end);
            }
        });
    }

    private SoyExpression invokeKeysFunction(SoyExpression soyExpression) {
        SoyType argType = soyExpression.soyType();
        SoyType listElementType = argType.getKind() == SoyType.Kind.MAP ? ((MapType)argType).getKeyType() : (argType.getKind() == SoyType.Kind.LIST ? IntType.getInstance() : UnknownType.getInstance());
        return SoyExpression.forList(ListType.of(listElementType), KEYS_FN.invoke(soyExpression.box().checkedCast(SoyMap.class)));
    }

    private SoyExpression invokeLengthFunction(SoyExpression soyExpression) {
        Expression lengthExpressionAsInt = soyExpression.isBoxed() ? soyExpression.checkedCast(SoyList.class).invoke(SOYLIST_LENGTH, new Expression[0]) : soyExpression.checkedCast(List.class).invoke(LIST_SIZE, new Expression[0]);
        return SoyExpression.forInt(BytecodeUtils.numericConversion(lengthExpressionAsInt, Type.LONG_TYPE));
    }

    private SoyExpression invokeMaxFunction(SoyExpression left, SoyExpression right) {
        if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
            return SoyExpression.forInt(MATH_MAX_LONG.invoke(left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
        }
        if (left.assignableToNullableFloat() && right.assignableToNullableFloat()) {
            return SoyExpression.forFloat(MATH_MAX_DOUBLE.invoke(left.unboxAs(Double.TYPE), right.unboxAs(Double.TYPE)));
        }
        return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MAX_FN.invoke(left.box(), right.box()));
    }

    private SoyExpression invokeMinFunction(SoyExpression left, SoyExpression right) {
        if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
            return SoyExpression.forInt(MATH_MIN_LONG.invoke(left.unboxAs(Long.TYPE), right.unboxAs(Long.TYPE)));
        }
        if (left.assignableToNullableFloat() && right.assignableToNullableFloat()) {
            return SoyExpression.forFloat(MATH_MIN_DOUBLE.invoke(left.unboxAs(Double.TYPE), right.unboxAs(Double.TYPE)));
        }
        return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MIN_FN.invoke(left.box(), right.box()));
    }

    private SoyExpression invokeRandomIntFunction(SoyExpression soyExpression) {
        return SoyExpression.forInt(RANDOM_INT_FN.invoke(soyExpression.unboxAs(Long.TYPE)));
    }

    private SoyExpression invokeRoundFunction(SoyExpression soyExpression) {
        if (soyExpression.assignableToNullableInt()) {
            return soyExpression;
        }
        if (soyExpression.assignableToNullableFloat()) {
            return SoyExpression.forInt(MATH_ROUND.invoke(soyExpression.unboxAs(Double.TYPE)));
        }
        return SoyExpression.forInt(ROUND_FN.invoke(soyExpression.box()));
    }

    private SoyExpression invokeRoundFunction(SoyExpression value, SoyExpression digitsAfterPoint) {
        return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, ROUND_WITH_NUM_DIGITS_AFTER_POINT_FN.invoke(value.box(), BytecodeUtils.numericConversion(digitsAfterPoint.unboxAs(Long.TYPE), Type.INT_TYPE)));
    }

    private SoyExpression invokeSoyFunction(FunctionNode node, List<SoyExpression> args) {
        Expression soyJavaFunctionExpr = MethodRef.RENDER_CONTEXT_GET_FUNCTION.invoke(this.parameterLookup.getRenderContext(), BytecodeUtils.constant(node.getFunctionName()));
        Expression list = SoyExpression.asBoxedList(args);
        return SoyExpression.forSoyValue(UnknownType.getInstance(), MethodRef.RUNTIME_CALL_SOY_FUNCTION.invoke(soyJavaFunctionExpr, list));
    }

    private SoyExpression invokeStrContainsFunction(SoyExpression left, SoyExpression right) {
        return SoyExpression.forBool(left.unboxAs(String.class).invoke(STRING_CONTAINS, right.coerceToString()));
    }

    private SoyExpression invokeStrIndexOfFunction(SoyExpression left, SoyExpression right) {
        return SoyExpression.forInt(BytecodeUtils.numericConversion(left.unboxAs(String.class).invoke(STRING_INDEX_OF, right.unboxAs(String.class)), Type.LONG_TYPE));
    }

    private SoyExpression invokeStrLenFunction(SoyExpression str) {
        return SoyExpression.forInt(BytecodeUtils.numericConversion(str.unboxAs(String.class).invoke(STRING_LENGTH, new Expression[0]), Type.LONG_TYPE));
    }

    private SoyExpression invokeStrSubFunction(SoyExpression str, SoyExpression startIndex) {
        return SoyExpression.forString(str.unboxAs(String.class).invoke(STRING_SUBSTR_START, BytecodeUtils.numericConversion(startIndex.unboxAs(Long.TYPE), Type.INT_TYPE)));
    }

    private SoyExpression invokeStrSubFunction(SoyExpression str, SoyExpression startIndex, SoyExpression endIndex) {
        return SoyExpression.forString(str.unboxAs(String.class).invoke(STRING_SUBSTR_START_END, BytecodeUtils.numericConversion(startIndex.unboxAs(Long.TYPE), Type.INT_TYPE), BytecodeUtils.numericConversion(endIndex.unboxAs(Long.TYPE), Type.INT_TYPE)));
    }
}

