/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internalutils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Descriptors;
import com.google.template.soy.data.SanitizedContent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public class NodeContentKinds {
    private static final ImmutableBiMap<String, SanitizedContent.ContentKind> KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP = ImmutableBiMap.builder().put((Object)"attributes", (Object)SanitizedContent.ContentKind.ATTRIBUTES).put((Object)"css", (Object)SanitizedContent.ContentKind.CSS).put((Object)"html", (Object)SanitizedContent.ContentKind.HTML).put((Object)"js", (Object)SanitizedContent.ContentKind.JS).put((Object)"text", (Object)SanitizedContent.ContentKind.TEXT).put((Object)"uri", (Object)SanitizedContent.ContentKind.URI).put((Object)"trusted_resource_uri", (Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI).build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"goog.soy.data.SanitizedHtml").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"goog.soy.data.SanitizedHtmlAttribute").put((Object)SanitizedContent.ContentKind.JS, (Object)"goog.soy.data.SanitizedJs").put((Object)SanitizedContent.ContentKind.URI, (Object)"goog.soy.data.SanitizedUri").put((Object)SanitizedContent.ContentKind.CSS, (Object)"goog.soy.data.SanitizedCss").put((Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, (Object)"goog.soy.data.SanitizedTrustedResourceUri").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"goog.soy.data.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> IDOM_KIND_TO_JS_CTOR_NAME = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"Function").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"Function").put((Object)SanitizedContent.ContentKind.JS, (Object)"goog.soy.data.SanitizedJs").put((Object)SanitizedContent.ContentKind.URI, (Object)"goog.soy.data.SanitizedUri").put((Object)SanitizedContent.ContentKind.CSS, (Object)"goog.soy.data.SanitizedCss").put((Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, (Object)"goog.soy.data.SanitizedTrustedResourceUri").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"goog.soy.data.UnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_ORDAINER_NAME = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"soydata.VERY_UNSAFE.ordainSanitizedHtml").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"soydata.VERY_UNSAFE.ordainSanitizedHtmlAttribute").put((Object)SanitizedContent.ContentKind.JS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedJs").put((Object)SanitizedContent.ContentKind.URI, (Object)"soydata.VERY_UNSAFE.ordainSanitizedUri").put((Object)SanitizedContent.ContentKind.CSS, (Object)"soydata.VERY_UNSAFE.ordainSanitizedCss").put((Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, (Object)"soydata.VERY_UNSAFE.ordainSanitizedTrustedResourceUri").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"soydata.markUnsanitizedText").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedHtmlForInternalBlocks").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedAttributesForInternalBlocks").put((Object)SanitizedContent.ContentKind.JS, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedJsForInternalBlocks").put((Object)SanitizedContent.ContentKind.URI, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedUriForInternalBlocks").put((Object)SanitizedContent.ContentKind.CSS, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedCssForInternalBlocks").put((Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, (Object)"soydata.VERY_UNSAFE.$$ordainSanitizedTrustedResourceUriForInternalBlocks").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"soydata.$$markUnsanitizedTextForInternalBlocks").build();
    private static final ImmutableMap<String, String> PROTO_TO_JS_UNPACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedHtml").put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedJs").put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedUri").put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedCss").put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedCss").put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)"soydata.unpackProtoToSanitizedTrustedResourceUri").build();
    private static final ImmutableMap<String, String> JS_TO_PROTO_PACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedHtmlToProtoSoyRuntimeOnly").put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedJsToProtoSoyRuntimeOnly").put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedUriToProtoSoyRuntimeOnly").put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedCssToSafeStyleProtoSoyRuntimeOnly").put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedCssToSafeStyleSheetProtoSoyRuntimeOnly").put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)"soydata.packSanitizedTrustedResourceUriToProtoSoyRuntimeOnly").build();
    private static final ImmutableMap<SanitizedContent.ContentKind, String> KIND_TO_PY_SANITIZED_NAME = ImmutableMap.builder().put((Object)SanitizedContent.ContentKind.HTML, (Object)"sanitize.SanitizedHtml").put((Object)SanitizedContent.ContentKind.ATTRIBUTES, (Object)"sanitize.SanitizedHtmlAttribute").put((Object)SanitizedContent.ContentKind.JS, (Object)"sanitize.SanitizedJs").put((Object)SanitizedContent.ContentKind.URI, (Object)"sanitize.SanitizedUri").put((Object)SanitizedContent.ContentKind.CSS, (Object)"sanitize.SanitizedCss").put((Object)SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI, (Object)"sanitize.SanitizedTrustedResourceUri").put((Object)SanitizedContent.ContentKind.TEXT, (Object)"sanitize.UnsanitizedText").build();

    public static SanitizedContent.ContentKind forAttributeValue(String attributeValue) {
        return (SanitizedContent.ContentKind)((Object)KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.get((Object)attributeValue));
    }

    public static String toAttributeValue(SanitizedContent.ContentKind kind) {
        return (String)KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.inverse().get((Object)kind);
    }

    public static Set<String> getAttributeValues() {
        return KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.keySet();
    }

    public static String toJsSanitizedContentCtorName(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_CTOR_NAME.get((Object)contentKind));
    }

    public static String toIDOMSanitizedContentCtorName(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)IDOM_KIND_TO_JS_CTOR_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainer(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_ORDAINER_NAME.get((Object)contentKind));
    }

    public static String toJsSanitizedContentOrdainerForInternalBlocks(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS.get((Object)contentKind));
    }

    public static String getJsImportForOrdainersFunctions(SanitizedContent.ContentKind contentKind) {
        if (contentKind == SanitizedContent.ContentKind.TEXT) {
            return "soydata";
        }
        return "soydata.VERY_UNSAFE";
    }

    public static String toJsPackFunction(Descriptors.Descriptor protoDescriptor) {
        return (String)Preconditions.checkNotNull((Object)JS_TO_PROTO_PACK_FN.get((Object)protoDescriptor.getFullName()));
    }

    public static String toJsUnpackFunction(Descriptors.Descriptor protoDescriptor) {
        return (String)Preconditions.checkNotNull((Object)PROTO_TO_JS_UNPACK_FN.get((Object)protoDescriptor.getFullName()));
    }

    public static String toPySanitizedContentOrdainer(SanitizedContent.ContentKind contentKind) {
        return (String)Preconditions.checkNotNull((Object)KIND_TO_PY_SANITIZED_NAME.get((Object)contentKind));
    }

    private NodeContentKinds() {
    }

    static {
        if (!KIND_TO_JS_CTOR_NAME.keySet().containsAll(EnumSet.allOf(SanitizedContent.ContentKind.class))) {
            throw new AssertionError((Object)"Not all ContentKind enums have a JS constructor");
        }
        if (!IDOM_KIND_TO_JS_CTOR_NAME.keySet().containsAll(EnumSet.allOf(SanitizedContent.ContentKind.class))) {
            throw new AssertionError((Object)"Not all ContentKind enums have a Incremental DOM JS constructor");
        }
        ImmutableSet soyContentKinds = KIND_ATTRIBUTE_TO_SANITIZED_CONTENT_KIND_BI_MAP.values();
        if (!KIND_TO_JS_ORDAINER_NAME.keySet().containsAll((Collection)soyContentKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!KIND_TO_JS_ORDAINER_NAME_FOR_INTERNAL_BLOCKS.keySet().containsAll((Collection)soyContentKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a JS ordainer");
        }
        if (!KIND_TO_PY_SANITIZED_NAME.keySet().containsAll((Collection)soyContentKinds)) {
            throw new AssertionError((Object)"Not all Soy-accessible ContentKind enums have a Python sanitizer");
        }
    }
}

