/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.StableSoyFileSupplier;
import com.google.template.soy.base.internal.VolatileSoyFileSupplier;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface SoyFileSupplier {
    public Reader open() throws IOException;

    public boolean hasChangedSince(Version var1);

    public SoyFileKind getSoyFileKind();

    public String getFilePath();

    public Version getVersion();

    public static final class Factory {
        private static final SoyErrorKind FILE_URL_SYNTAX = SoyErrorKind.of("file URL has invalid syntax: ''{0}''");

        public static SoyFileSupplier create(CharSource contentSource, SoyFileKind soyFileKind, String filePath) {
            return new StableSoyFileSupplier(contentSource, soyFileKind, filePath);
        }

        public static SoyFileSupplier create(File inputFile, SoyFileKind soyFileKind) {
            return Factory.create(Files.asCharSource((File)inputFile, (Charset)StandardCharsets.UTF_8), soyFileKind, inputFile.getPath());
        }

        public static SoyFileSupplier create(URL inputFileUrl, SoyFileKind soyFileKind, String filePath) {
            if (inputFileUrl.getProtocol().equals("file")) {
                URI inputFileUri;
                try {
                    inputFileUri = inputFileUrl.toURI();
                }
                catch (URISyntaxException ex) {
                    SoyError e = SoyError.DEFAULT_FACTORY.create(new SourceLocation(inputFileUrl.toString()), FILE_URL_SYNTAX, inputFileUrl);
                    SoyCompilationException sce = new SoyCompilationException((Iterable<SoyError>)ImmutableList.of((Object)e));
                    sce.initCause(ex);
                    throw sce;
                }
                return new VolatileSoyFileSupplier(new File(inputFileUri), soyFileKind);
            }
            return Factory.create(Resources.asCharSource((URL)inputFileUrl, (Charset)StandardCharsets.UTF_8), soyFileKind, filePath);
        }

        public static SoyFileSupplier create(URL inputFileUrl, SoyFileKind soyFileKind) {
            return Factory.create(inputFileUrl, soyFileKind, inputFileUrl.toString());
        }

        public static SoyFileSupplier create(CharSequence content, SoyFileKind soyFileKind, String filePath) {
            return Factory.create(CharSource.wrap((CharSequence)content), soyFileKind, filePath);
        }

        private Factory() {
        }
    }

    public static interface Version {
        public static final Version STABLE_VERSION = new Version(){};

        public boolean equals(Object var1);
    }
}

