/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class BaseUtils {
    private static final Set<String> KNOWN_EXISTING_DIRS = Sets.newHashSet();
    public static final String IDENT_RE = "[a-zA-Z_][a-zA-Z_0-9]*";
    private static final Pattern IDENT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    private static final Pattern IDENT_WITH_LEADING_DOT_PATTERN = Pattern.compile("[.][a-zA-Z_][a-zA-Z_0-9]*");
    public static final String DOTTED_IDENT_RE = "[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*";
    private static final Pattern DOTTED_IDENT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*(?:[.][a-zA-Z_][a-zA-Z_0-9]*)*");
    private static final Pattern LEADING_OR_TRAILING_UNDERSCORE_PATTERN = Pattern.compile("^_+|_+\\Z");
    private static final Pattern WORD_BOUNDARY_IN_IDENT_PATTERN = Pattern.compile("(?<= [a-zA-Z])(?= [A-Z][a-z])| (?<= [a-zA-Z])(?= [0-9])| (?<= [0-9])(?= [a-zA-Z])", 4);
    private static final Pattern CONSECUTIVE_UNDERSCORES_PATTERN = Pattern.compile("_ _ _*", 4);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final CharMatcher whitespaceCommaOrColon = CharMatcher.whitespace().or(CharMatcher.is((char)',')).or(CharMatcher.is((char)':')).precomputed();

    private BaseUtils() {
    }

    public static void ensureDirsExistInPath(String path) {
        String dirPath;
        if (path == null || path.length() == 0) {
            throw new AssertionError((Object)"ensureDirsExistInPath called with null or empty path.");
        }
        String string = dirPath = path.charAt(path.length() - 1) == File.separatorChar ? path.substring(0, path.length() - 1) : new File(path).getParent();
        if (dirPath == null || KNOWN_EXISTING_DIRS.contains(dirPath)) {
            return;
        }
        new File(dirPath).mkdirs();
        KNOWN_EXISTING_DIRS.add(dirPath);
    }

    public static boolean isIdentifier(String s) {
        return IDENT_PATTERN.matcher(s).matches();
    }

    public static boolean isIdentifierWithLeadingDot(String s) {
        return IDENT_WITH_LEADING_DOT_PATTERN.matcher(s).matches();
    }

    public static boolean isDottedIdentifier(String s) {
        return DOTTED_IDENT_PATTERN.matcher(s).matches();
    }

    public static String extractPartAfterLastDot(String dottedIdent) {
        int lastDotIndex = dottedIdent.lastIndexOf(46);
        return lastDotIndex == -1 ? dottedIdent : dottedIdent.substring(lastDotIndex + 1);
    }

    public static String convertToUpperUnderscore(String ident) {
        ident = LEADING_OR_TRAILING_UNDERSCORE_PATTERN.matcher(ident).replaceAll("");
        ident = WORD_BOUNDARY_IN_IDENT_PATTERN.matcher(ident).replaceAll("_");
        ident = CONSECUTIVE_UNDERSCORES_PATTERN.matcher(ident).replaceAll("_");
        return ident.toUpperCase();
    }

    public static String escapeToSoyString(String value, boolean shouldEscapeToAscii) {
        int codePoint;
        int len = value.length();
        StringBuilder out = new StringBuilder(len * 9 / 8);
        out.append('\'');
        block10: for (int i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            switch (codePoint) {
                case 10: {
                    out.append("\\n");
                    continue block10;
                }
                case 13: {
                    out.append("\\r");
                    continue block10;
                }
                case 9: {
                    out.append("\\t");
                    continue block10;
                }
                case 8: {
                    out.append("\\b");
                    continue block10;
                }
                case 12: {
                    out.append("\\f");
                    continue block10;
                }
                case 92: {
                    out.append("\\\\");
                    continue block10;
                }
                case 39: {
                    out.append("\\'");
                    continue block10;
                }
                case 34: {
                    out.append('\"');
                    continue block10;
                }
                default: {
                    if (shouldEscapeToAscii && (codePoint < 32 || codePoint >= 127)) {
                        BaseUtils.appendHexEscape(out, codePoint);
                        continue block10;
                    }
                    out.appendCodePoint(codePoint);
                }
            }
        }
        out.append('\'');
        return out.toString();
    }

    public static void appendHexEscape(StringBuilder out, int codePoint) {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            BaseUtils.appendHexEscape(out, surrogates[0]);
            BaseUtils.appendHexEscape(out, surrogates[1]);
        } else {
            out.append("\\u").append(HEX_DIGITS[codePoint >>> 12 & 0xF]).append(HEX_DIGITS[codePoint >>> 8 & 0xF]).append(HEX_DIGITS[codePoint >>> 4 & 0xF]).append(HEX_DIGITS[codePoint & 0xF]);
        }
    }

    public static String computePartialSha1AsHexString(String strToHash, int numBits) {
        Preconditions.checkArgument((numBits > 0 && numBits <= 160 && numBits % 8 == 0 ? 1 : 0) != 0);
        int numBytes = numBits / 8;
        return Hashing.sha1().hashString((CharSequence)strToHash, StandardCharsets.UTF_8).toString().substring(0, numBytes * 2);
    }

    public static String formatParseExceptionDetails(String errorToken, List<String> expectedTokens) {
        String details;
        ImmutableSet.Builder normalizedTokensBuilder = ImmutableSet.builder();
        for (String t : expectedTokens) {
            normalizedTokensBuilder.add((Object)BaseUtils.maybeQuoteForParseError(t));
        }
        expectedTokens = normalizedTokensBuilder.build().asList();
        int numExpectedTokens = expectedTokens.size();
        if (numExpectedTokens != 0) {
            StringBuilder builder = new StringBuilder(": expected ");
            for (int i = 0; i < numExpectedTokens; ++i) {
                builder.append((String)expectedTokens.get(i));
                if (i != numExpectedTokens - 1) {
                    builder.append(", ");
                }
                if (i != numExpectedTokens - 2) continue;
                builder.append("or ");
            }
            details = builder.toString();
        } else {
            details = "";
        }
        return String.format("parse error at '%s'%s", BaseUtils.escapeWhitespaceForErrorPrinting(errorToken), details);
    }

    private static String maybeQuoteForParseError(String token) {
        if (token.length() > 1 && token.charAt(0) == '\"' && token.charAt(token.length() - 1) == '\"') {
            token = token.substring(1, token.length() - 1);
        }
        if (whitespaceCommaOrColon.matchesAnyOf((CharSequence)token)) {
            token = "'" + token + "'";
        }
        return BaseUtils.escapeWhitespaceForErrorPrinting(token);
    }

    private static String escapeWhitespaceForErrorPrinting(String s) {
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\t", "\\\\t");
        return s;
    }
}

