/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.protobuf.Descriptors;
import java.util.HashSet;
import java.util.Set;

abstract class DescriptorTreeWalker {
    private final Set<String> visited = new HashSet<String>();

    DescriptorTreeWalker() {
    }

    void visitMessageDescriptor(Descriptors.Descriptor descriptor) {
    }

    void visitFieldDescriptor(Descriptors.FieldDescriptor descriptor) {
    }

    void visitEnumDescriptor(Descriptors.EnumDescriptor descriptor) {
    }

    void visitExtensionDescriptor(Descriptors.FieldDescriptor descriptor) {
    }

    private final void walkFileDescriptor(Descriptors.FileDescriptor fileDescriptor) {
        this.walkDescriptors(fileDescriptor.getMessageTypes());
        this.walkDescriptors(fileDescriptor.getExtensions());
        this.walkDescriptors(fileDescriptor.getEnumTypes());
    }

    final void walkDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
        for (Descriptors.GenericDescriptor genericDescriptor : descriptors) {
            this.walkDescriptor(genericDescriptor);
        }
    }

    final void walkDescriptor(Descriptors.GenericDescriptor descriptor) {
        if (!this.visited.add(descriptor.getFullName())) {
            return;
        }
        if (descriptor instanceof Descriptors.FileDescriptor) {
            this.walkFileDescriptor((Descriptors.FileDescriptor)descriptor);
        } else if (descriptor instanceof Descriptors.Descriptor) {
            this.walkMessageDescriptor((Descriptors.Descriptor)descriptor);
        } else if (descriptor instanceof Descriptors.FieldDescriptor) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor;
            if (fieldDescriptor.isExtension()) {
                this.visitExtensionDescriptor(fieldDescriptor);
            } else {
                this.visitFieldDescriptor(fieldDescriptor);
            }
        } else if (descriptor instanceof Descriptors.EnumDescriptor) {
            this.visitEnumDescriptor((Descriptors.EnumDescriptor)descriptor);
        }
    }

    private final void walkMessageDescriptor(Descriptors.Descriptor descriptor) {
        this.visitMessageDescriptor(descriptor);
        this.walkDescriptors(descriptor.getNestedTypes());
        this.walkDescriptors(descriptor.getExtensions());
        this.walkDescriptors(descriptor.getEnumTypes());
        this.walkDescriptors(descriptor.getFields());
    }
}

