/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Set;

public enum AutoescapeMode {
    NONCONTEXTUAL("deprecated-noncontextual"),
    CONTEXTUAL("deprecated-contextual"),
    STRICT("strict");

    private static final ImmutableMap<String, AutoescapeMode> valueToModeMap;
    private final String attributeValue;

    private AutoescapeMode(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        return valueToModeMap.keySet();
    }

    static AutoescapeMode forAttributeValue(String autoescapeModeStr) {
        return (AutoescapeMode)((Object)valueToModeMap.get((Object)autoescapeModeStr));
    }

    static {
        ImmutableSortedMap.Builder map = ImmutableSortedMap.naturalOrder();
        for (AutoescapeMode value : AutoescapeMode.values()) {
            map.put((Object)value.attributeValue, (Object)value);
        }
        valueToModeMap = map.build();
    }
}

