/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.types.SoyType;
import java.util.LinkedHashMap;
import java.util.List;

public final class TranslateToPyExprVisitor
extends AbstractReturningExprNodeVisitor<PyExpr> {
    private static final SoyErrorKind PROTO_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Proto accessors are not supported in pysrc.");
    private static final SoyErrorKind PROTO_INIT_NOT_SUPPORTED = SoyErrorKind.of("Proto init is not supported in pysrc.");
    private static final SoyErrorKind SOY_PY_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Failed to find SoyPySrcFunction ''{0}''.");
    private static final PyExpr ERROR = new PyExpr("raise Exception('Soy compilation failed')", Integer.MAX_VALUE);
    private final LocalVariableStack localVarExprs;
    private final ErrorReporter errorReporter;

    TranslateToPyExprVisitor(LocalVariableStack localVarExprs, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.localVarExprs = localVarExprs;
    }

    @Override
    protected PyExpr visitExprRootNode(ExprRootNode node) {
        return (PyExpr)this.visit(node.getRoot());
    }

    @Override
    protected PyExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new PyExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitStringNode(StringNode node) {
        return new PyStringExpr(node.toSourceString());
    }

    @Override
    protected PyExpr visitNullNode(NullNode node) {
        return new PyExpr("None", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitBooleanNode(BooleanNode node) {
        return new PyExpr(node.getValue() ? "True" : "False", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitListLiteralNode(ListLiteralNode node) {
        return PyExprUtils.convertIterableToPyListExpr(Iterables.transform(node.getChildren(), (Function)new Function<ExprNode, PyExpr>(){

            public PyExpr apply(ExprNode node) {
                return (PyExpr)TranslateToPyExprVisitor.this.visit(node);
            }
        }));
    }

    @Override
    protected PyExpr visitMapLiteralNode(MapLiteralNode node) {
        Preconditions.checkArgument((node.numChildren() % 2 == 0 ? 1 : 0) != 0);
        LinkedHashMap<PyExpr, PyExpr> dict = new LinkedHashMap<PyExpr, PyExpr>();
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            ExprNode keyNode = node.getChild(i);
            ExprNode valueNode = node.getChild(i + 1);
            dict.put((PyExpr)this.visit(keyNode), (PyExpr)this.visit(valueNode));
        }
        return PyExprUtils.convertMapToOrderedDict(dict);
    }

    @Override
    protected PyExpr visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected PyExpr visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private PyExpr visitNullSafeNode(ExprNode node) {
        StringBuilder nullSafetyPrefix = new StringBuilder();
        String refText = this.visitNullSafeNodeRecurse(node, nullSafetyPrefix);
        if (nullSafetyPrefix.length() == 0) {
            return new PyExpr(refText, Integer.MAX_VALUE);
        }
        return new PyExpr(nullSafetyPrefix + refText, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }

    private String visitNullSafeNodeRecurse(ExprNode node, StringBuilder nullSafetyPrefix) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                VarRefNode varRef = (VarRefNode)node;
                if (varRef.isInjected()) {
                    return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess("ijData", varRef.getName());
                }
                PyExpr translation = this.localVarExprs.getVariableExpression(varRef.getName());
                if (translation != null) {
                    return translation.getText();
                }
                return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess("data", varRef.getName());
            }
            case FIELD_ACCESS_NODE: 
            case ITEM_ACCESS_NODE: {
                DataAccessNode dataAccess = (DataAccessNode)node;
                String refText = this.visitNullSafeNodeRecurse(dataAccess.getBaseExprChild(), nullSafetyPrefix);
                if (dataAccess.isNullSafe()) {
                    nullSafetyPrefix.append("None if ").append(refText).append(" is None else ");
                }
                if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                    FieldAccessNode fieldAccess = (FieldAccessNode)node;
                    return this.genCodeForFieldAccess(fieldAccess, fieldAccess.getBaseExprChild().getType(), refText, fieldAccess.getFieldName());
                }
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                SoyType.Kind baseKind = itemAccess.getBaseExprChild().getType().getKind();
                PyExpr keyPyExpr = (PyExpr)this.visit(itemAccess.getKeyExprChild());
                if (baseKind == SoyType.Kind.MAP || baseKind == SoyType.Kind.RECORD) {
                    return TranslateToPyExprVisitor.genCodeForKeyAccess(refText, keyPyExpr.getText());
                }
                return new PyFunctionExprBuilder("runtime.key_safe_data_access").addArg(new PyExpr(refText, Integer.MAX_VALUE)).addArg(keyPyExpr).build();
            }
        }
        PyExpr value = (PyExpr)this.visit(node);
        return PyExprUtils.maybeProtect(value, Integer.MAX_VALUE).getText();
    }

    @Override
    protected PyExpr visitGlobalNode(GlobalNode node) {
        return (PyExpr)this.visit(node.getValue());
    }

    @Override
    protected PyExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genPyExprUsingSoySyntax(node);
    }

    @Override
    protected PyExpr visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List children = this.visitChildren(node);
        PyExpr conditionalExpr = PyExprUtils.genPyNotNullCheck((PyExpr)children.get(0));
        PyExpr trueExpr = (PyExpr)children.get(0);
        PyExpr falseExpr = (PyExpr)children.get(1);
        return this.genTernaryConditional(conditionalExpr, trueExpr, falseExpr);
    }

    @Override
    protected PyExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("not runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", PyExprUtils.pyPrecedenceForOperator(Operator.NOT));
    }

    @Override
    protected PyExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_add(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Operator op = Operator.CONDITIONAL;
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        List operandExprs = this.visitChildren(node);
        Operator.Operand conditionalOperand = (Operator.Operand)syntax.get(0);
        PyExpr conditionalExpr = (PyExpr)operandExprs.get(conditionalOperand.getIndex());
        Operator.Operand trueOperand = (Operator.Operand)syntax.get(4);
        PyExpr trueExpr = (PyExpr)operandExprs.get(trueOperand.getIndex());
        Operator.Operand falseOperand = (Operator.Operand)syntax.get(8);
        PyExpr falseExpr = (PyExpr)operandExprs.get(falseOperand.getIndex());
        return this.genTernaryConditional(conditionalExpr, trueExpr, falseExpr);
    }

    @Override
    protected PyExpr visitFunctionNode(FunctionNode node) {
        SoyFunction soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            return this.visitNonPluginFunction(node, (BuiltinFunction)soyFunction);
        }
        if (soyFunction instanceof SoyPySrcFunction) {
            List<PyExpr> args = this.visitChildren(node);
            return ((SoyPySrcFunction)soyFunction).computeForPySrc(args);
        }
        this.errorReporter.report(node.getSourceLocation(), SOY_PY_SRC_FUNCTION_NOT_FOUND, node.getFunctionName());
        return ERROR;
    }

    private PyExpr visitNonPluginFunction(FunctionNode node, BuiltinFunction nonpluginFn) {
        switch (nonpluginFn) {
            case IS_FIRST: {
                return this.visitForEachFunction(node, "__isFirst");
            }
            case IS_LAST: {
                return this.visitForEachFunction(node, "__isLast");
            }
            case INDEX: {
                return this.visitForEachFunction(node, "__index");
            }
            case QUOTE_KEYS_IF_JS: {
                return this.visitMapLiteralNode((MapLiteralNode)node.getChild(0));
            }
            case CHECK_NOT_NULL: {
                return this.visitCheckNotNull(node);
            }
        }
        throw new AssertionError();
    }

    private PyExpr visitCheckNotNull(FunctionNode node) {
        PyExpr childExpr = (PyExpr)this.visit(node.getChild(0));
        return new PyFunctionExprBuilder("runtime.check_not_null").addArg(childExpr).asPyExpr();
    }

    private PyExpr visitForEachFunction(FunctionNode node, String suffix) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.localVarExprs.getVariableExpression(varName + suffix);
    }

    private static String genCodeForLiteralKeyAccess(String containerExpr, String key) {
        return TranslateToPyExprVisitor.genCodeForKeyAccess(containerExpr, "'" + key + "'");
    }

    private static String genCodeForKeyAccess(String containerExpr, String keyName) {
        return containerExpr + ".get(" + keyName + ")";
    }

    private String genCodeForFieldAccess(ExprNode node, SoyType baseType, String containerExpr, String fieldName) {
        if (baseType != null && baseType.getKind() == SoyType.Kind.PROTO) {
            this.errorReporter.report(node.getSourceLocation(), PROTO_ACCESS_NOT_SUPPORTED, new Object[0]);
            return ".ERROR";
        }
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(containerExpr, fieldName);
    }

    private PyExpr genPyExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        List operandPyExprs = this.visitChildren(opNode);
        String newExpr = PyExprUtils.genExprWithNewToken(opNode.getOperator(), operandPyExprs, null);
        return new PyExpr(newExpr, PyExprUtils.pyPrecedenceForOperator(opNode.getOperator()));
    }

    private PyExpr genTernaryConditional(PyExpr conditionalExpr, PyExpr trueExpr, PyExpr falseExpr) {
        int conditionalPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL);
        StringBuilder exprSb = new StringBuilder().append(PyExprUtils.maybeProtect(trueExpr, conditionalPrecedence).getText()).append(" if ").append(PyExprUtils.maybeProtect(conditionalExpr, conditionalPrecedence).getText()).append(" else ").append(PyExprUtils.maybeProtect(falseExpr, conditionalPrecedence).getText());
        return new PyExpr(exprSb.toString(), conditionalPrecedence);
    }

    @Override
    protected PyExpr visitProtoInitNode(ProtoInitNode node) {
        this.errorReporter.report(node.getSourceLocation(), PROTO_INIT_NOT_SUPPORTED, new Object[0]);
        return ERROR;
    }
}

