/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.ConditionalBranches;
import com.google.template.soy.soytree.TagName;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;

final class HtmlTagEntry {
    private final TagName tagName;
    private final ConditionalBranches branches;
    private static final SoyErrorKind UNSUPPORTED_HTML_TAG_NODE = SoyErrorKind.of("Strict HTML validation only supports matching tags that are raw texts or print commands.");
    private static final SoyErrorKind MISMATCH_DYNAMIC_TAG = SoyErrorKind.of("The print commands need to be identical for dynamic tags.");
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG = SoyErrorKind.of("Unexpected HTML close tag.");
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG_WITH_EXPECTATION = SoyErrorKind.of("Unexpected HTML close tag. Expected: ''{0}''.");
    private static final SoyErrorKind OPEN_TAG_NOT_CLOSED = SoyErrorKind.of("Expected tag to be closed.");
    private static final SoyErrorKind MISMATCH_TAG = SoyErrorKind.of("Could not find a match for this HTML tag.");

    HtmlTagEntry(TagName tagName) {
        this.tagName = tagName;
        this.branches = null;
    }

    HtmlTagEntry(ConditionalBranches branches) {
        this.tagName = null;
        this.branches = new ConditionalBranches(branches);
    }

    boolean hasTagName() {
        return this.tagName != null;
    }

    @Nullable
    TagName getTagName() {
        return this.tagName;
    }

    @Nullable
    ConditionalBranches getBranches() {
        return this.branches;
    }

    SourceLocation getSourceLocation() {
        if (this.hasTagName()) {
            return this.tagName.getTagLocation();
        }
        for (ConditionalBranches.ConditionalBranch branch : this.branches.getBranches()) {
            if (branch.deque().isEmpty()) continue;
            return branch.deque().peek().getSourceLocation();
        }
        return SourceLocation.UNKNOWN;
    }

    public String toString() {
        return this.hasTagName() ? this.tagName.toString() : this.branches.toString();
    }

    public static boolean matchOrError(ArrayDeque<HtmlTagEntry> openStack, ArrayDeque<HtmlTagEntry> closeQueue, ErrorReporter errorReporter) {
        while (!openStack.isEmpty() && !closeQueue.isEmpty()) {
            if (HtmlTagEntry.matchOrError(openStack.pop(), closeQueue.poll(), errorReporter)) continue;
            return false;
        }
        if (!openStack.isEmpty()) {
            errorReporter.report(openStack.peek().getSourceLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
            return false;
        }
        if (!closeQueue.isEmpty()) {
            errorReporter.report(closeQueue.getFirst().getSourceLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean matchOrError(TagName openTag, TagName closeTag, ErrorReporter errorReporter) {
        if (openTag.isStatic() != closeTag.isStatic()) {
            errorReporter.report(closeTag.getTagLocation(), UNSUPPORTED_HTML_TAG_NODE, new Object[0]);
            return false;
        }
        if (!openTag.equals(closeTag)) {
            if (openTag.isStatic()) {
                errorReporter.report(closeTag.getTagLocation(), UNEXPECTED_CLOSE_TAG_WITH_EXPECTATION, openTag.getStaticTagNameAsLowerCase().get());
            } else {
                errorReporter.report(closeTag.getTagLocation(), MISMATCH_DYNAMIC_TAG, new Object[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean matchOrError(HtmlTagEntry openTag, HtmlTagEntry closeTag, ErrorReporter errorReporter) {
        if (openTag.hasTagName() != closeTag.hasTagName()) {
            boolean matchCommonPrefix = false;
            if (openTag.hasTagName()) {
                TagName openTagName = openTag.getTagName();
                if (closeTag.getBranches().hasCommonPrefix(openTagName)) {
                    closeTag.getBranches().popAllBranches();
                    matchCommonPrefix = true;
                    if (!closeTag.getBranches().isEmpty()) {
                        matchCommonPrefix = false;
                        errorReporter.report(closeTag.getSourceLocation(), UNEXPECTED_CLOSE_TAG_WITH_EXPECTATION, openTagName.getStaticTagNameAsLowerCase().get());
                    }
                } else {
                    errorReporter.report(openTagName.getTagLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
                }
            } else {
                TagName closeTagName = closeTag.getTagName();
                if (openTag.getBranches().hasCommonPrefix(closeTagName)) {
                    openTag.getBranches().popAllBranches();
                    matchCommonPrefix = true;
                    if (!openTag.getBranches().isEmpty()) {
                        matchCommonPrefix = false;
                        errorReporter.report(openTag.getSourceLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
                    }
                } else {
                    errorReporter.report(closeTagName.getTagLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
                }
            }
            return matchCommonPrefix;
        }
        if (openTag.hasTagName()) {
            return HtmlTagEntry.matchOrError(openTag.getTagName(), closeTag.getTagName(), errorReporter);
        }
        List<ConditionalBranches.ConditionalBranch> openBranches = openTag.getBranches().getBranches();
        List<ConditionalBranches.ConditionalBranch> closeBranches = closeTag.getBranches().getBranches();
        SourceLocation location = closeTag.getSourceLocation();
        if (openBranches.size() != closeBranches.size()) {
            errorReporter.report(location, MISMATCH_TAG, new Object[0]);
            return false;
        }
        for (int i = 0; i < openBranches.size(); ++i) {
            ConditionalBranches.ConditionalBranch openBranch = openBranches.get(i);
            ConditionalBranches.ConditionalBranch closeBranch = closeBranches.get(i);
            if (!openBranch.condition().equals(closeBranch.condition())) {
                errorReporter.report(location, MISMATCH_TAG, new Object[0]);
                return false;
            }
            ArrayDeque<HtmlTagEntry> openStack = openBranch.deque();
            ArrayDeque<HtmlTagEntry> closeQueue = closeBranch.deque();
            if (openStack.size() != closeQueue.size()) {
                errorReporter.report(location, MISMATCH_TAG, new Object[0]);
                return false;
            }
            while (!openStack.isEmpty() && !closeQueue.isEmpty()) {
                if (HtmlTagEntry.matchOrError(openStack.pop(), closeQueue.poll(), errorReporter)) continue;
                return false;
            }
        }
        return true;
    }
}

