/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ExprUnionEquivalence;
import java.util.List;

abstract class Condition {
    Condition() {
    }

    abstract Condition copy();

    abstract boolean isDefaultCond();

    static Condition getEmptyCondition() {
        return EmptyCondition.INSTANCE;
    }

    static Condition createIfCondition() {
        return new IfCondition();
    }

    static Condition createIfCondition(ExprUnion expr) {
        return new IfCondition(expr);
    }

    static Condition createSwitchCondition(ExprUnion switchExpr, List<ExprUnion> caseExprs) {
        return new SwitchCondition(switchExpr, caseExprs);
    }

    private static final class SwitchCondition
    extends Condition {
        private final ExprUnion switchExpr;
        private final ImmutableList<ExprUnion> caseExprs;

        SwitchCondition(ExprUnion switchExpr, List<ExprUnion> caseExprs) {
            this.switchExpr = switchExpr;
            this.caseExprs = ImmutableList.copyOf(caseExprs);
        }

        @Override
        boolean isDefaultCond() {
            return this.caseExprs.isEmpty();
        }

        @Override
        Condition copy() {
            return new SwitchCondition(this.switchExpr, (List<ExprUnion>)this.caseExprs);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof SwitchCondition) {
                SwitchCondition cond = (SwitchCondition)object;
                return ExprUnionEquivalence.get().equivalent(this.switchExpr, cond.switchExpr) && ExprUnionEquivalence.get().pairwise().equivalent(this.caseExprs, cond.caseExprs);
            }
            return false;
        }

        public int hashCode() {
            return 31 * ExprUnionEquivalence.get().hash(this.switchExpr) + ExprUnionEquivalence.get().pairwise().hash(this.caseExprs);
        }
    }

    private static final class IfCondition
    extends Condition {
        private final Optional<ExprUnion> expr;

        IfCondition() {
            this.expr = Optional.absent();
        }

        IfCondition(ExprUnion expr) {
            this.expr = Optional.of((Object)expr);
        }

        IfCondition(IfCondition condition) {
            this.expr = condition.expr.isPresent() ? Optional.of((Object)((ExprUnion)condition.expr.get()).copy(new CopyState())) : Optional.absent();
        }

        @Override
        boolean isDefaultCond() {
            return !this.expr.isPresent();
        }

        @Override
        Condition copy() {
            return new IfCondition(this);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof IfCondition) {
                IfCondition cond = (IfCondition)object;
                return ExprUnionEquivalence.get().equivalent(this.expr.orNull(), cond.expr.orNull());
            }
            return false;
        }

        public int hashCode() {
            return ExprUnionEquivalence.get().hash(this.expr.orNull());
        }
    }

    private static final class EmptyCondition
    extends Condition {
        private static final EmptyCondition INSTANCE = new EmptyCondition();

        private EmptyCondition() {
        }

        @Override
        EmptyCondition copy() {
            return INSTANCE;
        }

        @Override
        boolean isDefaultCond() {
            return true;
        }
    }
}

