/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class CheckGlobalsPass
extends CompilerFilePass {
    private static final SoyErrorKind UNBOUND_GLOBAL = SoyErrorKind.of("Unbound global ''{0}''.");
    private final ErrorReporter errorReporter;

    CheckGlobalsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (GlobalNode global : SoyTreeUtils.getAllNodesOfType(file, GlobalNode.class)) {
            if (global.isResolved() || global.shouldSuppressUnknownGlobalErrors()) continue;
            this.errorReporter.report(global.getSourceLocation(), UNBOUND_GLOBAL, global.getName());
        }
    }
}

