/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import java.util.List;

public final class SoyJsPluginUtils {
    private static final Function<CodeChunk.WithValue, JsExpr> TO_JS_EXPR = new Function<CodeChunk.WithValue, JsExpr>(){

        public JsExpr apply(CodeChunk.WithValue chunk) {
            return chunk.singleExprOrName();
        }
    };

    private SoyJsPluginUtils() {
    }

    public static JsExpr genJsExprUsingSoySyntax(Operator op, List<JsExpr> operandJsExprs) {
        List operands = Lists.transform(operandJsExprs, (Function)new Function<JsExpr, CodeChunk.WithValue>(){

            public CodeChunk.WithValue apply(JsExpr input) {
                return CodeChunk.fromExpr(input);
            }
        });
        return CodeChunk.operation(op, operands, null).assertExpr();
    }

    public static CodeChunk.WithValue applyDirective(CodeChunk.Generator generator, CodeChunk.WithValue expr, SoyJsSrcPrintDirective directive, List<CodeChunk.WithValue> args) {
        List argExprs = Lists.transform(args, TO_JS_EXPR);
        JsExpr applied = directive.applyForJsSrc(expr.singleExprOrName(), argExprs);
        boolean isSingleExpr = expr.isRepresentableAsSingleExpression();
        for (CodeChunk.WithValue arg : args) {
            if (arg.isRepresentableAsSingleExpression()) continue;
            isSingleExpr = false;
            break;
        }
        return isSingleExpr ? CodeChunk.fromExpr(applied) : generator.newChunk().statement(expr).statements(args).assign(CodeChunk.fromExpr(applied)).buildAsValue();
    }
}

