/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.template.soy.jssrc.dsl.AutoValue_Declaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OutputContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import javax.annotation.Nullable;

abstract class Declaration
extends CodeChunk.WithValue {
    Declaration() {
    }

    abstract String varName();

    abstract CodeChunk.WithValue rhs();

    @Nullable
    abstract String closureCompilerTypeExpression();

    static Declaration create(@Nullable String closureCompilerTypeExpression, String varName, CodeChunk.WithValue rhs) {
        return new AutoValue_Declaration(varName, rhs, closureCompilerTypeExpression);
    }

    @Override
    String getCode(int startingIndent, OutputContext outputContext, boolean moreToCome) {
        FormattingContext ctx = new FormattingContext(startingIndent);
        this.formatInitialStatements(ctx, moreToCome);
        return ctx.toString();
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        this.rhs().formatInitialStatements(ctx, moreToCome);
        if (!moreToCome) {
            this.rhs().formatOutputExpr(ctx, OutputContext.EXPRESSION);
            ctx.append(';').endLine();
            return;
        }
        if (this.closureCompilerTypeExpression() != null) {
            ctx.append("/** @type {").append(this.closureCompilerTypeExpression()).append("} */").endLine();
        }
        ctx.append("var ").append(this.varName()).append(" = ");
        this.rhs().formatOutputExpr(ctx, OutputContext.EXPRESSION);
        ctx.append(";").endLine();
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
        ctx.append(this.varName());
    }

    @Override
    public boolean isRepresentableAsSingleExpression() {
        return this.rhs().isRepresentableAsSingleExpression();
    }

    @Override
    public JsExpr singleExprOrName() {
        return new JsExpr(this.varName(), Integer.MAX_VALUE);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.rhs().collectRequires(collector);
    }
}

