/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Call;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.OutputContext;

abstract class Call
extends Operation {
    Call() {
    }

    abstract CodeChunk.WithValue receiver();

    abstract ImmutableList<CodeChunk.WithValue> args();

    static Call create(CodeChunk.WithValue receiver, ImmutableList<CodeChunk.WithValue> args) {
        return new AutoValue_Call(receiver, args);
    }

    @Override
    int precedence() {
        return Integer.MAX_VALUE;
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.Associativity.LEFT;
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.receiver().collectRequires(collector);
        for (CodeChunk.WithValue arg : this.args()) {
            arg.collectRequires(collector);
        }
    }

    @Override
    public boolean isRepresentableAsSingleExpression() {
        if (!this.receiver().isRepresentableAsSingleExpression()) {
            return false;
        }
        for (CodeChunk.WithValue arg : this.args()) {
            if (arg.isRepresentableAsSingleExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
        this.formatOperand(this.receiver(), OperandPosition.LEFT, ctx);
        ctx.append('(');
        boolean first = true;
        for (CodeChunk.WithValue arg : this.args()) {
            if (first) {
                first = false;
            } else {
                ctx.append(", ");
            }
            arg.formatOutputExpr(ctx, OutputContext.EXPRESSION);
        }
        ctx.append(')');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        this.receiver().formatInitialStatements(ctx, true);
        for (int i = 0; i < this.args().size(); ++i) {
            ((CodeChunk.WithValue)this.args().get(i)).formatInitialStatements(ctx, moreToCome || i < this.args().size() - 1);
        }
    }
}

