/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;

final class UnsupportedFeatureReporter {
    private final SoyNodeVisitor errorChecker;
    private final ErrorReporter errorReporter;

    UnsupportedFeatureReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.errorChecker = new SoyNodeVisitor();
    }

    void check(SoyNode node) {
        this.errorChecker.exec(node);
    }

    private class ExprNodeVisitor
    extends AbstractExprNodeVisitor<Void> {
        private ExprNodeVisitor() {
        }

        @Override
        protected final void visitVarRefNode(VarRefNode node) {
            VarDefn defn = node.getDefnDecl();
            switch (defn.kind()) {
                case IJ_PARAM: 
                case LOCAL_VAR: 
                case PARAM: {
                    break;
                }
                case UNDECLARED: {
                    UnsupportedFeatureReporter.this.errorReporter.report(node.getSourceLocation(), SoyErrorKind.of("jbcsrc does not support undeclared template params"), new Object[0]);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }
    }

    private class SoyNodeVisitor
    extends AbstractSoyNodeVisitor<Void> {
        final ExprNodeVisitor exprVisitor;

        SoyNodeVisitor() {
            this.exprVisitor = new ExprNodeVisitor();
        }

        @Override
        protected void visitSoyFileNode(SoyFileNode node) {
            super.visitSoyFileNode(node);
            NamespaceDeclaration namespaceDeclaration = node.getNamespaceDeclaration();
            if (namespaceDeclaration.getDefaultAutoescapeMode() != AutoescapeMode.STRICT) {
                UnsupportedFeatureReporter.this.errorReporter.report(namespaceDeclaration.getAutoescapeModeLocation(), SoyErrorKind.of("jbcsrc only supports strict autoescape templates, found : ''{0}''"), new Object[]{namespaceDeclaration.getDefaultAutoescapeMode()});
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            if (node instanceof SoyNode.ExprHolderNode) {
                for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)node).getAllExprUnions()) {
                    if (exprUnion.getExpr() == null) {
                        UnsupportedFeatureReporter.this.errorReporter.report(node.getSourceLocation(), SoyErrorKind.of("jbcsrc does not support soy v1 expressions: {0}"), exprUnion.getExprText());
                        continue;
                    }
                    this.exprVisitor.exec(exprUnion.getExpr());
                }
            }
        }
    }
}

