/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.html.HtmlDefinitions;
import com.google.template.soy.html.IncrementalHtmlAttributeNode;
import com.google.template.soy.html.IncrementalHtmlCloseTagNode;
import com.google.template.soy.html.IncrementalHtmlOpenTagNode;
import com.google.template.soy.incrementaldomsrc.AssistantForHtmlMsgs;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomCodeBuilder;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcUtils;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenDirectivePluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final SoyErrorKind PRINT_ATTR_INVALID_KIND = SoyErrorKind.of("For Incremental DOM, '{print}' statements in attributes context can only be of kind attributes (since they must compile to semantic attribute declarations).  {0} is not allowed.");
    private static final SoyErrorKind PRINT_ATTR_INVALID_VALUE = SoyErrorKind.of("Attribute values that cannot be evalutated to simple expressions are not yet supported for Incremental DOM code generation.");
    private static final SoyErrorKind NULL_COALESCING_NON_EMPTY = SoyErrorKind.of("The only supported conditional for attribute and HTML values in incremental DOM is '{'$value ?: '''''}'.  The right operand must be empty.");
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";
    private static final String KEY_ATTRIBUTE_NAME = "key";

    @Inject
    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, IncrementalDomDelTemplateNamer incrementalDomDelTemplateNamer, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genIncrementalDomExprsVisitorFactory, GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor, SoyTypeOps typeOps) {
        super(jsSrcOptions, jsExprTranslator, incrementalDomDelTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genIncrementalDomExprsVisitorFactory, genDirectivePluginRequiresVisitor, typeOps);
    }

    @Override
    protected JsCodeBuilder createCodeBuilder() {
        return new IncrementalDomCodeBuilder();
    }

    @Override
    protected IncrementalDomCodeBuilder createChildJsCodeBuilder() {
        return new IncrementalDomCodeBuilder(this.getJsCodeBuilder());
    }

    @Override
    protected IncrementalDomCodeBuilder getJsCodeBuilder() {
        return (IncrementalDomCodeBuilder)super.getJsCodeBuilder();
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        super.addCodeToRequireGeneralDeps(soyFile);
        this.getJsCodeBuilder().addGoogRequire("goog.asserts", true);
        this.getJsCodeBuilder().addGoogRequire("goog.string", true);
        this.getJsCodeBuilder().appendLine("var IncrementalDom = goog.require('incrementaldom');").appendLine("var ie_open = IncrementalDom.elementOpen;").appendLine("var ie_close = IncrementalDom.elementClose;").appendLine("var ie_void = IncrementalDom.elementVoid;").appendLine("var ie_open_start = IncrementalDom.elementOpenStart;").appendLine("var ie_open_end = IncrementalDom.elementOpenEnd;").appendLine("var itext = IncrementalDom.text;").appendLine("var iattr = IncrementalDom.attr;").appendLine("var soyIdom = goog.require('soy.idom');").appendLine("var dyn = soyIdom.renderDynamicContent;").appendLine("var print = soyIdom.print;");
    }

    @Override
    protected String getJsTypeName(SoyType type) {
        return IncrementalDomSrcUtils.getJsTypeName(type);
    }

    @Override
    protected String getTemplateReturnType(TemplateNode node) {
        if (node.getContentKind() == SanitizedContent.ContentKind.TEXT) {
            return "string";
        }
        return "void";
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.getJsCodeBuilder().setContentKind(node.getContentKind());
        super.visitTemplateNode(node);
    }

    @Override
    protected void generateFunctionBody(TemplateNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = this.isTextContent(node.getContentKind());
        if (isTextTemplate) {
            jsCodeBuilder.appendLine("var output = '';");
            jsCodeBuilder.pushOutputVar("output").setOutputVarInited();
        }
        this.genParamTypeChecks(node);
        this.visitChildren(node);
        if (isTextTemplate) {
            jsCodeBuilder.appendLine("return output;");
            jsCodeBuilder.popOutputVar();
        }
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContent.ContentKind prevContentKind = jsCodeBuilder.getContentKind();
        jsCodeBuilder.pushOutputVar(generatedVarName).setOutputVarInited();
        jsCodeBuilder.setContentKind(node.getContentKind());
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        switch (node.getContentKind()) {
            case HTML: 
            case ATTRIBUTES: {
                jsCodeBuilder.appendLine("var " + generatedVarName, " = function() {");
                jsCodeBuilder.increaseIndent();
                this.visitChildren(node);
                jsCodeBuilder.decreaseIndent();
                jsCodeBuilder.appendLine("};");
                break;
            }
            default: {
                jsCodeBuilder.appendLine("var ", generatedVarName, " = '';");
                this.visitChildren(node);
            }
        }
        jsCodeBuilder.setContentKind(prevContentKind);
        jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.visitLetParamContentNode(node, generatedVarName);
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(generatedVarName));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        CodeChunk.WithValue call = this.genCallCodeUtils.gen(node, this.templateAliases, this.templateTranslationContext, this.errorReporter);
        switch (this.getJsCodeBuilder().getContentKind()) {
            case ATTRIBUTES: {
                this.getJsCodeBuilder().append(call);
                break;
            }
            case HTML: {
                Optional<SanitizedContent.ContentKind> kind = this.templateRegistry.getCallContentKind(node);
                if (!kind.isPresent()) {
                    call = CodeChunk.id("dyn").call(call);
                } else if (this.isTextContent((SanitizedContent.ContentKind)((Object)kind.get()))) {
                    call = this.generateTextCall(call);
                }
                this.getJsCodeBuilder().append(call);
                break;
            }
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: 
            case CSS: 
            case TEXT: {
                this.getJsCodeBuilder().addChunkToOutputVar(call);
            }
        }
    }

    @Override
    protected void visitIfNode(IfNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContent.ContentKind currentContentKind = jsCodeBuilder.getContentKind();
        if (currentContentKind == SanitizedContent.ContentKind.ATTRIBUTES || currentContentKind == SanitizedContent.ContentKind.HTML) {
            super.generateNonExpressionIfNode(node);
        } else {
            super.visitIfNode(node);
        }
    }

    private CodeChunk.WithValue generateTextCall(CodeChunk.WithValue textValue) {
        CodeChunk.Generator cg = this.templateTranslationContext.codeGenerator();
        CodeChunk.WithValue var = cg.declare(textValue);
        return cg.newChunk().statement(CodeChunk.dottedId("goog.asserts.assert").call(var.doubleNotEquals(CodeChunk.WithValue.LITERAL_NULL))).statement(CodeChunk.id("itext").call(var)).buildAsValue();
    }

    private boolean isTextContent(SanitizedContent.ContentKind contentKind) {
        return contentKind != SanitizedContent.ContentKind.HTML && contentKind != SanitizedContent.ContentKind.ATTRIBUTES;
    }

    @Override
    protected void visitIncrementalHtmlAttributeNode(IncrementalHtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.append(CodeChunk.id("iattr").call(CodeChunk.stringLiteral(node.getName()), CodeChunkUtils.concatChunks(this.getAttributeValues(node))));
    }

    private List<CodeChunk.WithValue> getAttributeValues(IncrementalHtmlAttributeNode node) {
        if (node.getChildren().isEmpty()) {
            return ImmutableList.of((Object)CodeChunk.WithValue.LITERAL_EMPTY_STRING);
        }
        if (!this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            this.errorReporter.report(node.getSourceLocation(), PRINT_ATTR_INVALID_VALUE, new Object[0]);
            return ImmutableList.of();
        }
        return this.genJsExprsVisitor.execOnChildren(node);
    }

    private void emitOpenStartEndAndVisitSubtree(IncrementalHtmlOpenTagNode node, String tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        ArrayList<CodeChunk.WithValue> args = new ArrayList<CodeChunk.WithValue>();
        args.add(CodeChunk.stringLiteral(tagName));
        CodeChunk.WithValue keyValue = this.maybeGetKeyNodeValue(node);
        if (keyValue != null) {
            args.add(keyValue);
        }
        jsCodeBuilder.append(CodeChunk.id("ie_open_start").call(args));
        jsCodeBuilder.increaseIndentTwice();
        this.visitChildren(node);
        jsCodeBuilder.decreaseIndentTwice();
        jsCodeBuilder.append(CodeChunk.id("ie_open_end").call(new CodeChunk.WithValue[0]));
    }

    @Override
    protected void visitIncrementalHtmlOpenTagNode(IncrementalHtmlOpenTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (node.getChildren().isEmpty()) {
            ArrayList<CodeChunk.WithValue> args = new ArrayList<CodeChunk.WithValue>();
            args.add(CodeChunk.stringLiteral(node.getTagName()));
            CodeChunk.WithValue keyValue = this.maybeGetKeyNodeValue(node);
            if (keyValue != null) {
                args.add(keyValue);
            }
            jsCodeBuilder.append(CodeChunk.id("ie_open").call(args));
        } else {
            this.emitOpenStartEndAndVisitSubtree(node, node.getTagName());
        }
        jsCodeBuilder.increaseIndent();
        if (HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    @Nullable
    private CodeChunk.WithValue maybeGetKeyNodeValue(IncrementalHtmlOpenTagNode parentNode) {
        for (SoyNode.StandaloneNode childNode : parentNode.getChildren()) {
            IncrementalHtmlAttributeNode htmlAttributeNode;
            if (!(childNode instanceof IncrementalHtmlAttributeNode) || !(htmlAttributeNode = (IncrementalHtmlAttributeNode)childNode).getName().equals(KEY_ATTRIBUTE_NAME)) continue;
            Preconditions.checkState((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(htmlAttributeNode), (Object)"Attribute values that cannot be evalutated to simple expressions is not yet supported for Incremental DOM code generation");
            List<CodeChunk.WithValue> chunks = this.genJsExprsVisitor.execOnChildren(htmlAttributeNode);
            return CodeChunkUtils.concatChunks(chunks);
        }
        return null;
    }

    @Override
    protected void visitIncrementalHtmlCloseTagNode(IncrementalHtmlCloseTagNode node) {
        if (!HtmlDefinitions.HTML5_VOID_ELEMENTS.contains((Object)node.getTagName())) {
            this.emitClose(node.getTagName());
        }
    }

    private void emitClose(String tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.decreaseIndent();
        jsCodeBuilder.append(CodeChunk.id("ie_close").call(CodeChunk.stringLiteral(tagName)));
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        CodeChunk.WithValue textArg = CodeChunk.stringLiteral(node.getRawText());
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (node.getHtmlContext() == HtmlContext.HTML_PCDATA) {
            jsCodeBuilder.append(CodeChunk.id("itext").call(textArg));
        } else {
            jsCodeBuilder.addChunkToOutputVar(textArg);
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        ExprUnion exprUnion = node.getExprUnion();
        ExprRootNode expr = exprUnion.getExpr();
        List<ExprNode> exprNodes = expr.getChildren();
        ExprNode firstNode = exprNodes.get(0);
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                if (this.tryGenerateFunctionCall(SoyType.Kind.ATTRIBUTES, firstNode) != GenerateFunctionCallResult.INDIRECT_NODE) break;
                this.errorReporter.report(node.getSourceLocation(), PRINT_ATTR_INVALID_KIND, new Object[]{firstNode.getType().getKind()});
                break;
            }
            case HTML_PCDATA: {
                if (this.tryGenerateFunctionCall(SoyType.Kind.HTML, firstNode) != GenerateFunctionCallResult.INDIRECT_NODE) break;
                List<CodeChunk.WithValue> chunks = this.genJsExprsVisitor.exec(node);
                CodeChunk.WithValue printCall = CodeChunk.id("print").call(CodeChunkUtils.concatChunks(chunks));
                IncrementalDomCodeBuilder codeBuilder = this.getJsCodeBuilder();
                codeBuilder.append(printCall);
                break;
            }
            default: {
                super.visitPrintNode(node);
            }
        }
    }

    private GenerateFunctionCallResult tryGenerateFunctionCall(SoyType.Kind expectedKind, ExprNode expr) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (expr instanceof VarRefNode && expr.getType().getKind() == expectedKind) {
            VarRefNode varRefNode = (VarRefNode)expr;
            CodeChunk.WithValue call = this.templateTranslationContext.soyToJsVariableMappings().get(varRefNode.getName()).call(new CodeChunk.WithValue[0]);
            jsCodeBuilder.append(call);
            return GenerateFunctionCallResult.EMITTED;
        }
        if (!(expr instanceof OperatorNodes.NullCoalescingOpNode)) {
            return GenerateFunctionCallResult.INDIRECT_NODE;
        }
        OperatorNodes.NullCoalescingOpNode opNode = (OperatorNodes.NullCoalescingOpNode)expr;
        if (!(opNode.getLeftChild() instanceof VarRefNode) || !(opNode.getRightChild() instanceof StringNode) || opNode.getLeftChild().getType().getKind() != expectedKind) {
            return GenerateFunctionCallResult.INDIRECT_NODE;
        }
        if (!((StringNode)opNode.getRightChild()).getValue().isEmpty()) {
            this.errorReporter.report(expr.getSourceLocation(), NULL_COALESCING_NON_EMPTY, new Object[0]);
            return GenerateFunctionCallResult.ILLEGAL_NODE;
        }
        VarRefNode varRefNode = (VarRefNode)opNode.getLeftChild();
        CodeChunk.WithValue varName = this.templateTranslationContext.soyToJsVariableMappings().get(varRefNode.getName());
        CodeChunk conditionalCall = this.templateTranslationContext.codeGenerator().newChunk().if_(varName, varName.call(new CodeChunk.WithValue[0])).endif().build();
        jsCodeBuilder.append(conditionalCall);
        return GenerateFunctionCallResult.EMITTED;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        switch (node.getHtmlContext()) {
            case HTML_PCDATA: {
                new AssistantForHtmlMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter).generateMsgGroupCode(node);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                String msgExpression = new AssistantForAttributeMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter).generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(CodeChunk.dottedId("goog.string.unescapeEntities").call(CodeChunk.id(msgExpression)));
                break;
            }
            default: {
                String msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(CodeChunk.id(msgExpression));
            }
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    private static final class AssistantForAttributeMsgs
    extends GenJsCodeVisitorAssistantForMsgs {
        AssistantForAttributeMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
            super(master, jsSrcOptions, jsExprTranslator, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter);
        }

        @Override
        protected CodeChunk.WithValue genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
            CodeChunk.WithValue toEscape = super.genGoogMsgPlaceholder(msgPhNode);
            return CodeChunk.dottedId("soy.$$escapeHtml").call(toEscape);
        }
    }

    private static enum GenerateFunctionCallResult {
        EMITTED,
        ILLEGAL_NODE,
        INDIRECT_NODE;

    }
}

