/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.aggregate;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import java.util.Map;
import java.util.Objects;

public final class RecordType
implements SoyObjectType {
    private final ImmutableSortedMap<String, SoyType> members;

    private RecordType(Map<String, ? extends SoyType> members) {
        this.members = ImmutableSortedMap.copyOf(members);
    }

    public static RecordType of(Map<String, ? extends SoyType> members) {
        return new RecordType(members);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.RECORD;
    }

    @Override
    public boolean isAssignableFrom(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.RECORD) {
            RecordType srcRecord = (RecordType)srcType;
            for (Map.Entry entry : this.members.entrySet()) {
                SoyType fieldType = (SoyType)srcRecord.members.get(entry.getKey());
                if (fieldType != null && ((SoyType)entry.getValue()).isAssignableFrom(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        return value instanceof SoyRecord;
    }

    @Override
    public String getName() {
        return "Record";
    }

    public ImmutableSortedMap<String, SoyType> getMembers() {
        return this.members;
    }

    @Override
    public String getNameForBackend(SoyBackendKind backend) {
        return "Object";
    }

    @Override
    public SoyType getFieldType(String fieldName) {
        return (SoyType)this.members.get((Object)fieldName);
    }

    @Override
    public ImmutableSet<String> getFieldNames() {
        return this.members.keySet();
    }

    @Override
    public String getFieldAccessExpr(String fieldContainerExpr, String fieldName, SoyBackendKind backendKind) {
        if (backendKind == SoyBackendKind.JS_SRC) {
            return fieldContainerExpr + "." + fieldName;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSet<String> getFieldAccessImports(String fieldName, SoyBackendKind backend) {
        return ImmutableSet.of();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Map.Entry entry : this.members.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append((String)entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((RecordType)other).members.equals(this.members);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.members);
    }
}

