/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Optional;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.primitive.FloatType;
import java.util.Collection;
import javax.inject.Inject;

public final class SoyTypeOps {
    private final SoyTypeRegistry typeRegistry;

    @Inject
    public SoyTypeOps(SoyTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public SoyTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public SoyType computeLowestCommonType(SoyType t0, SoyType t1) {
        if (t0.isAssignableFrom(t1)) {
            return t0;
        }
        if (t1.isAssignableFrom(t0)) {
            return t1;
        }
        return this.typeRegistry.getOrCreateUnionType(t0, t1);
    }

    public SoyType computeLowestCommonType(Collection<SoyType> types) {
        SoyType result = null;
        for (SoyType type : types) {
            result = result == null ? type : this.computeLowestCommonType(result, type);
        }
        return result;
    }

    public Optional<SoyType> computeLowestCommonTypeArithmetic(SoyType t0, SoyType t1) {
        if (!this.isNumericOrUnknown(t0) || !this.isNumericOrUnknown(t1)) {
            return Optional.absent();
        }
        if (t0.isAssignableFrom(t1)) {
            return Optional.of((Object)t0);
        }
        if (t1.isAssignableFrom(t0)) {
            return Optional.of((Object)t1);
        }
        return Optional.of((Object)FloatType.getInstance());
    }

    public boolean isNumericOrUnknown(SoyType t0) {
        return t0.getKind() == SoyType.Kind.UNKNOWN || SoyTypes.NUMBER_TYPE.isAssignableFrom(t0);
    }
}

