/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.soyparse.Token;

final class Tokens {
    Tokens() {
    }

    static SourceLocation createSrcLoc(String filePath, Token first, Token ... rest) {
        int beginLine = first.beginLine;
        int beginColumn = first.beginColumn;
        int endLine = first.endLine;
        int endColumn = first.endColumn;
        for (Token next : rest) {
            Preconditions.checkArgument((boolean)Tokens.startsLaterThan(next, beginLine, beginColumn));
            Preconditions.checkArgument((boolean)Tokens.endsLaterThan(next, endLine, endColumn));
            endLine = next.endLine;
            endColumn = next.endColumn;
        }
        return new SourceLocation(filePath, beginLine, beginColumn, endLine, endColumn);
    }

    private static boolean startsLaterThan(Token tok, int beginLine, int beginCol) {
        return tok.beginLine > beginLine || tok.beginLine == beginLine && tok.beginColumn > beginCol;
    }

    private static boolean endsLaterThan(Token tok, int endLine, int endCol) {
        return tok.endLine > endLine || tok.endLine == endLine && tok.endColumn > endCol;
    }
}

