/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;

final class CheckInvalidParamsVisitor {
    private static final SoyErrorKind IJ_CSP_NONCE_REFERENCE = SoyErrorKind.of("Found a use of the injected parameter ''csp_nonce''. This parameter is reserved by the Soy compiler for Content Security Policy support.");
    private final ErrorReporter errorReporter;

    CheckInvalidParamsVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    void exec(SoyNode node) {
        SoytreeUtils.visitAllNodes(node, (NodeVisitor<? super Node, Boolean>)new NodeVisitor<Node, Boolean>(){

            @Override
            public Boolean exec(Node node) {
                VarDefn defn;
                if (node instanceof TemplateNode) {
                    TemplateNode template = (TemplateNode)node;
                    for (TemplateParam param : template.getAllParams()) {
                        if (!param.isInjected() || !param.name().equals("csp_nonce")) continue;
                        CheckInvalidParamsVisitor.this.errorReporter.report(node.getSourceLocation(), IJ_CSP_NONCE_REFERENCE, new Object[0]);
                    }
                }
                if (node instanceof VarRefNode && (defn = ((VarRefNode)node).getDefnDecl()).kind() == VarDefn.Kind.IJ_PARAM && defn.name().equals("csp_nonce")) {
                    CheckInvalidParamsVisitor.this.errorReporter.report(node.getSourceLocation(), IJ_CSP_NONCE_REFERENCE, new Object[0]);
                }
                return true;
            }
        });
    }
}

