/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.passes.FindIndirectParamsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class CheckCallingParamTypesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind ARGUMENT_TYPE_MISMATCH = SoyErrorKind.of("Type mismatch on param {0}: expected: {1}, actual: {2}.");
    private static final SoyErrorKind PASSING_PROTOBUF_FROM_STRICT_TO_NON_STRICT = SoyErrorKind.of("Passing protobuf {0} of type {1} to non-strict template not allowed.");
    private final TemplateRegistry templateRegistry;
    private TemplateNode callerTemplate;
    private final Map<TemplateNode, TemplateParamTypes> paramTypesMap = new HashMap<TemplateNode, TemplateParamTypes>();
    private final ErrorReporter errorReporter;

    CheckCallingParamTypesVisitor(TemplateRegistry registry, ErrorReporter errorReporter) {
        this.templateRegistry = registry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee != null) {
            Set<TemplateParam> paramsToRuntimeCheck = this.checkCallParamTypes(node, callee);
            node.setParamsToRuntimeCheck(paramsToRuntimeCheck);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        ImmutableMap.Builder paramsToCheckByTemplate = ImmutableMap.builder();
        ImmutableListMultimap<String, TemplateDelegateNode> delTemplateNameToValues = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues();
        for (TemplateDelegateNode delTemplate : delTemplateNameToValues.get((Object)node.getDelCalleeName())) {
            Set<TemplateParam> params = this.checkCallParamTypes(node, delTemplate);
            paramsToCheckByTemplate.put((Object)delTemplate, (Object)ImmutableList.copyOf(params));
        }
        node.setParamsToRuntimeCheck((ImmutableMap<TemplateDelegateNode, ImmutableList<TemplateParam>>)paramsToCheckByTemplate.build());
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.callerTemplate = node;
        this.visitChildren(node);
        this.callerTemplate = null;
    }

    private Set<TemplateParam> checkCallParamTypes(CallNode call, TemplateNode callee) {
        TemplateParamTypes calleeParamTypes = this.getTemplateParamTypes(callee);
        HashSet<String> explicitParams = new HashSet<String>();
        HashSet paramNamesToRuntimeCheck = new HashSet(calleeParamTypes.params.keySet());
        paramNamesToRuntimeCheck.removeAll(calleeParamTypes.indirectParamNames);
        for (CallParamNode callParamNode : call.getChildren()) {
            SoyType argType = null;
            if (callParamNode.getKind() == SoyNode.Kind.CALL_PARAM_VALUE_NODE) {
                ExprRootNode expr = ((CallParamValueNode)callParamNode).getValueExprUnion().getExpr();
                if (expr != null) {
                    argType = expr.getType();
                }
            } else if (callParamNode.getKind() == SoyNode.Kind.CALL_PARAM_CONTENT_NODE) {
                SanitizedContent.ContentKind contentKind = ((CallParamContentNode)callParamNode).getContentKind();
                argType = contentKind == null ? StringType.getInstance() : SanitizedType.getTypeForContentKind(contentKind);
            }
            String paramName = callParamNode.getKey();
            if (argType != null) {
                Collection declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                boolean staticTypeSafe = true;
                for (SoyType formalType : declaredParamTypes) {
                    staticTypeSafe &= this.checkArgumentAgainstParamType(callParamNode.getSourceLocation(), paramName, argType, formalType, calleeParamTypes);
                }
                if (staticTypeSafe) {
                    paramNamesToRuntimeCheck.remove(paramName);
                }
            }
            explicitParams.add(paramName);
        }
        if (call.dataAttribute().isPassingData() && call.dataAttribute().isPassingAllData() && this.callerTemplate.getParams() != null) {
            for (TemplateParam templateParam : this.callerTemplate.getParams()) {
                String paramName;
                if (!(templateParam instanceof HeaderParam) || explicitParams.contains(paramName = templateParam.name())) continue;
                Collection declaredParamTypes = calleeParamTypes.params.get((Object)paramName);
                boolean staticTypeSafe = true;
                for (SoyType formalType : declaredParamTypes) {
                    staticTypeSafe &= this.checkArgumentAgainstParamType(call.getSourceLocation(), paramName, templateParam.type(), formalType, calleeParamTypes);
                }
                if (!staticTypeSafe) continue;
                paramNamesToRuntimeCheck.remove(paramName);
            }
        }
        HashSet<TemplateParam> paramsToRuntimeCheck = new HashSet<TemplateParam>();
        for (TemplateParam param : callee.getParams()) {
            if (!paramNamesToRuntimeCheck.remove(param.name())) continue;
            paramsToRuntimeCheck.add(param);
        }
        Preconditions.checkState((boolean)paramNamesToRuntimeCheck.isEmpty(), (String)"Unexpected callee params %s", (Object[])new Object[]{paramNamesToRuntimeCheck});
        return paramsToRuntimeCheck;
    }

    private boolean checkArgumentAgainstParamType(SourceLocation location, String paramName, SoyType argType, SoyType formalType, TemplateParamTypes calleeParams) {
        if (!calleeParams.isStrictlyTyped && formalType.getKind() == SoyType.Kind.UNKNOWN || formalType.getKind() == SoyType.Kind.ANY) {
            if (argType instanceof SoyProtoType) {
                this.errorReporter.report(location, PASSING_PROTOBUF_FROM_STRICT_TO_NON_STRICT, paramName, argType);
            }
        } else if (argType.getKind() != SoyType.Kind.UNKNOWN && !formalType.isAssignableFrom(argType)) {
            if (calleeParams.isIndirect(paramName) && argType.getKind() == SoyType.Kind.UNION && ((UnionType)argType).isNullable() && SoyTypes.makeNullable(formalType).isAssignableFrom(argType)) {
                return false;
            }
            this.errorReporter.report(location, ARGUMENT_TYPE_MISMATCH, paramName, formalType, argType);
        }
        return true;
    }

    private TemplateParamTypes getTemplateParamTypes(TemplateNode node) {
        TemplateParamTypes paramTypes = this.paramTypesMap.get(node);
        if (paramTypes == null) {
            paramTypes = new TemplateParamTypes();
            if (node.getParams() != null) {
                for (TemplateParam param : node.getParams()) {
                    if (param.declLoc() == TemplateParam.DeclLoc.SOY_DOC) {
                        paramTypes.isStrictlyTyped = false;
                    }
                    Preconditions.checkNotNull((Object)param.type());
                    paramTypes.params.put((Object)param.name(), (Object)param.type());
                }
            }
            FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramTypes.params.containsKey((Object)indirectParamName)) continue;
                paramTypes.params.putAll((Object)indirectParamName, (Iterable)ipi.indirectParamTypes.get((Object)indirectParamName));
                paramTypes.indirectParamNames.add(indirectParamName);
            }
            this.paramTypesMap.put(node, paramTypes);
        }
        return paramTypes;
    }

    private static class TemplateParamTypes {
        public boolean isStrictlyTyped = true;
        public final Multimap<String, SoyType> params = HashMultimap.create();
        public final Set<String> indirectParamNames = new HashSet<String>();

        private TemplateParamTypes() {
        }

        public boolean isIndirect(String paramName) {
            return this.indirectParamNames.contains(paramName);
        }
    }
}

