/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

final class CheckEscapingSanityVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind ILLEGAL_PRINT_DIRECTIVE = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n- {0} can only be used internally by the Soy compiler.");
    private static final SoyErrorKind LET_WITHOUT_KIND = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n- In strict templates, '{'let'}'...'{'/let'}' blocks require an explicit kind=\"<html|css|text|attributes>\".");
    private static final SoyErrorKind PARAM_WITHOUT_KIND = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n- In strict templates, '{'param'}'...'{'/param'}' blocks require an explicit kind=\"<html|css|text|attributes>\".");
    private static final SoyErrorKind STRICT_TEXT_CALL_FROM_NONCONTEXTUAL_TEMPLATE = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n- Calls to strict templates with ''kind=\"text\"'' are not allowed in non-contextually autoescaped templates.");
    private AutoescapeMode autoescapeMode;
    private final TemplateRegistry templateRegistry;
    private final ErrorReporter errorReporter;

    CheckEscapingSanityVisitor(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.autoescapeMode = node.getAutoescapeMode();
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintDirectiveNode(PrintDirectiveNode node) {
        EscapingMode escapingMode = EscapingMode.fromDirective(node.getName());
        if (escapingMode != null && escapingMode.isInternalOnly) {
            this.errorReporter.report(node.getSourceLocation(), ILLEGAL_PRINT_DIRECTIVE, node.getName());
        }
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitRenderUnitNode(node, LET_WITHOUT_KIND);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee;
        if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && (callee = this.templateRegistry.getBasicTemplate(node.getCalleeName())) != null && callee.getContentKind() == SanitizedContent.ContentKind.TEXT) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_TEXT_CALL_FROM_NONCONTEXTUAL_TEMPLATE, new Object[0]);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        TemplateNode callee;
        ImmutableList divisions;
        if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && !(divisions = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName())).isEmpty() && (callee = (TemplateNode)divisions.get(0)).getContentKind() == SanitizedContent.ContentKind.TEXT) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_TEXT_CALL_FROM_NONCONTEXTUAL_TEMPLATE, new Object[0]);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitRenderUnitNode(node, PARAM_WITHOUT_KIND);
    }

    private void visitRenderUnitNode(SoyNode.RenderUnitNode node, SoyErrorKind errorKind) {
        AutoescapeMode oldMode = this.autoescapeMode;
        if (node.getContentKind() != null) {
            this.autoescapeMode = AutoescapeMode.STRICT;
        } else if (this.autoescapeMode == AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), errorKind, new Object[0]);
        }
        this.visitChildren(node);
        this.autoescapeMode = oldMode;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

