/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.jbcsrc.AbstractMemoryClassLoader;
import com.google.template.soy.jbcsrc.ClassData;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class CompilingClassLoader
extends AbstractMemoryClassLoader {
    private final Map<String, ClassData> classesByName = Collections.synchronizedMap(new HashMap());
    private final CompiledTemplateRegistry registry;

    CompilingClassLoader(CompiledTemplateRegistry registry) {
        this.registry = registry;
    }

    @Override
    ClassData getClassData(String name) {
        ClassData classDef = this.classesByName.get(name);
        if (classDef != null) {
            return classDef;
        }
        boolean isFactory = name.endsWith("$Factory");
        String compiledTemplateName = isFactory ? name.substring(0, name.length() - ("Factory".length() + 1)) : name;
        CompiledTemplateMetadata meta = this.registry.getTemplateInfoByClassName(compiledTemplateName);
        if (meta == null) {
            return null;
        }
        ClassData clazzToLoad = null;
        for (ClassData clazz : new TemplateCompiler(this.registry, meta).compile()) {
            String className = clazz.type().className();
            if (className.equals(name)) {
                clazzToLoad = clazz;
                continue;
            }
            this.classesByName.put(className, clazz);
        }
        return clazzToLoad;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

