/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import javax.annotation.Nullable;

public final class BidiGlobalDir {
    public static final BidiGlobalDir LTR = new BidiGlobalDir(1);
    public static final BidiGlobalDir RTL = new BidiGlobalDir(-1);
    private final String codeSnippet;
    private final int staticValue;

    private BidiGlobalDir(int staticValue) {
        this.staticValue = staticValue;
        this.codeSnippet = Integer.toString(staticValue);
    }

    private BidiGlobalDir(String codeSnippet) {
        this.codeSnippet = codeSnippet;
        this.staticValue = 0;
    }

    public static BidiGlobalDir forStaticIsRtl(boolean isRtl) {
        return isRtl ? RTL : LTR;
    }

    public static BidiGlobalDir forStaticLocale(@Nullable String localeString) {
        return SoyBidiUtils.getBidiGlobalDir(localeString);
    }

    public static BidiGlobalDir forIsRtlCodeSnippet(String isRtlCodeSnippet, SoyBackendKind backend) {
        Preconditions.checkArgument((isRtlCodeSnippet != null && isRtlCodeSnippet.length() > 0 ? 1 : 0) != 0, (Object)"Bidi global direction source code snippet must be non-empty.");
        Preconditions.checkArgument((backend == SoyBackendKind.JS_SRC || backend == SoyBackendKind.PYTHON_SRC ? 1 : 0) != 0, (Object)"Bidi code snippets are only used in JS and Python.");
        if (backend == SoyBackendKind.JS_SRC) {
            return new BidiGlobalDir(isRtlCodeSnippet + "?-1:1");
        }
        return new BidiGlobalDir("-1 if " + isRtlCodeSnippet + " else 1");
    }

    public boolean isStaticValue() {
        return this.staticValue != 0;
    }

    public int getStaticValue() {
        if (this.staticValue == 0) {
            throw new RuntimeException("Cannot get static value for nonstatic BidiGlobalDir object.");
        }
        return this.staticValue;
    }

    public String getCodeSnippet() {
        return this.codeSnippet;
    }
}

