/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.primitive.IntType;

public final class IntegerNode
extends AbstractPrimitiveNode {
    private final int value;

    public IntegerNode(int value, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.value = value;
    }

    private IntegerNode(IntegerNode orig, CopyState copyState) {
        super(orig, copyState);
        this.value = orig.value;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.INTEGER_NODE;
    }

    @Override
    public SoyType getType() {
        return IntType.getInstance();
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toSourceString() {
        return Integer.toString(this.value);
    }

    @Override
    public IntegerNode copy(CopyState copyState) {
        return new IntegerNode(this, copyState);
    }
}

