/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyCustomValueConverter;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.SoyProtoTypeImpl;
import com.google.template.soy.types.proto.SoyProtoTypeProvider;
import com.google.template.soy.types.proto.SoyProtoValue;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.inject.Inject;

public final class SoyProtoValueConverter
implements SoyCustomValueConverter {
    private final SoyTypeRegistry registry;
    private final SoyProtoTypeProvider protoTypeProvider;
    private static final Map<Class<?>, Function<? super Object, ? extends SoyValueProvider>> CONVERTER_FOR_VALUE_CLASS = ImmutableMap.builder().put(SafeHtml.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeHtml((SafeHtml)soyInput);
        }
    }).put(SafeHtmlProto.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeHtmlProto((SafeHtmlProto)soyInput);
        }
    }).put(SafeScript.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeScript((SafeScript)soyInput);
        }
    }).put(SafeScriptProto.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeScriptProto((SafeScriptProto)soyInput);
        }
    }).put(SafeStyle.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeStyle((SafeStyle)soyInput);
        }
    }).put(SafeStyleProto.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeStyleProto((SafeStyleProto)soyInput);
        }
    }).put(SafeStyleSheet.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeStyleSheet((SafeStyleSheet)soyInput);
        }
    }).put(SafeStyleSheetProto.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeStyleSheetProto((SafeStyleSheetProto)soyInput);
        }
    }).put(SafeUrl.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeUrl((SafeUrl)soyInput);
        }
    }).put(SafeUrlProto.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromSafeUrlProto((SafeUrlProto)soyInput);
        }
    }).put(TrustedResourceUrl.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromTrustedResourceUrl((TrustedResourceUrl)soyInput);
        }
    }).put(TrustedResourceUrlProto.class, (Object)new Function<Object, SoyValueProvider>(){

        public SoyValueProvider apply(Object soyInput) {
            return SanitizedContents.fromTrustedResourceUrlProto((TrustedResourceUrlProto)soyInput);
        }
    }).build();

    @VisibleForTesting
    public SoyProtoValueConverter() {
        this(new SoyTypeRegistry(), SoyProtoTypeProvider.empty());
    }

    @Inject
    SoyProtoValueConverter(SoyTypeRegistry registry, SoyProtoTypeProvider protoTypeProvider) {
        this.registry = registry;
        this.protoTypeProvider = protoTypeProvider;
    }

    @Override
    public SoyValueProvider convert(SoyValueConverter valueConverter, Object obj) {
        SoyValueProvider valueProvider;
        if (obj instanceof Message.Builder) {
            obj = ((Message.Builder)obj).build();
        }
        if ((valueProvider = SoyProtoValueConverter.tryToConvertToValueType(obj)) != null) {
            return valueProvider;
        }
        if (obj instanceof Message) {
            Message message = (Message)obj;
            SoyProtoTypeImpl type = this.protoTypeProvider.getType(message.getDescriptorForType(), this.registry);
            return new SoyProtoValue(valueConverter, type, message);
        }
        if (obj instanceof ByteString) {
            return StringData.forValue(BaseEncoding.base64().encode(((ByteString)obj).toByteArray()));
        }
        if (obj instanceof Descriptors.EnumValueDescriptor) {
            return IntegerData.forValue(((Descriptors.EnumValueDescriptor)obj).getNumber());
        }
        if (obj instanceof ProtocolMessageEnum) {
            return IntegerData.forValue(((ProtocolMessageEnum)obj).getNumber());
        }
        return null;
    }

    private static SoyValueProvider tryToConvertToValueType(Object obj) {
        if (obj == null) {
            return null;
        }
        Function<? super Object, ? extends SoyValueProvider> converter = CONVERTER_FOR_VALUE_CLASS.get(obj.getClass());
        if (converter != null) {
            return (SoyValueProvider)converter.apply(obj);
        }
        return null;
    }

    static {
        for (Class<?> cl : CONVERTER_FOR_VALUE_CLASS.keySet()) {
            if (!Modifier.isFinal(cl.getModifiers())) {
                throw new AssertionError((Object)(cl + " is not final so there might be subclasses that aren't keyed in this map"));
            }
        }
    }
}

