/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CaseFormat;
import com.google.protobuf.Descriptors;
import com.google.template.soy.types.proto.Protos;

class JsQualifiedNameHelper {
    JsQualifiedNameHelper() {
    }

    static String getQualifiedExtensionName(Descriptors.FieldDescriptor field) {
        Descriptors.Descriptor scope = field.getExtensionScope();
        if (scope != null) {
            return JsQualifiedNameHelper.getQualifiedName(scope) + "." + JsQualifiedNameHelper.computeSoyName(field);
        }
        return Protos.getJsPackage(field.getFile()) + "." + JsQualifiedNameHelper.computeSoyName(field);
    }

    static String getImportForExtension(Descriptors.FieldDescriptor field) {
        Descriptors.Descriptor scope = field.getExtensionScope();
        if (scope != null) {
            while (scope.getContainingType() != null) {
                scope = scope.getContainingType();
            }
            return JsQualifiedNameHelper.getQualifiedName(scope);
        }
        return Protos.getJsPackage(field.getFile()) + "." + JsQualifiedNameHelper.computeSoyName(field);
    }

    static String getQualifiedName(Descriptors.Descriptor descriptor) {
        String protoPackage = descriptor.getFile().getPackage();
        String name = descriptor.getFullName();
        if (!name.startsWith(protoPackage)) {
            throw new AssertionError((Object)("Expected \"" + name + "\" to start with \"" + protoPackage + "\""));
        }
        return Protos.getJsPackage(descriptor.getFile()) + name.substring(protoPackage.length());
    }

    private static String computeSoyName(Descriptors.FieldDescriptor field) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
    }
}

