/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.aggregate;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.types.SoyType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;

public final class UnionType
implements SoyType {
    private static final Predicate<SoyType> IS_NULL = new Predicate<SoyType>(){

        public boolean apply(SoyType memberType) {
            return memberType.getKind() == SoyType.Kind.NULL;
        }
    };
    private static final Comparator<SoyType> MEMBER_ORDER = new Comparator<SoyType>(){

        @Override
        public int compare(SoyType st1, SoyType st2) {
            return st1.toString().compareTo(st2.toString());
        }
    };
    private final ImmutableSortedSet<SoyType> members;

    private UnionType(Iterable<? extends SoyType> members) {
        this.members = ImmutableSortedSet.copyOf(MEMBER_ORDER, members);
        Preconditions.checkArgument((this.members.size() != 1 ? 1 : 0) != 0);
        for (SoyType type : this.members) {
            if (type.getKind() != SoyType.Kind.UNKNOWN) continue;
            throw new IllegalArgumentException("Cannot create unions containing unknown: " + this.members);
        }
    }

    public static SoyType of(SoyType ... members) {
        return UnionType.of(Arrays.asList(members));
    }

    public static SoyType of(Collection<SoyType> members) {
        ImmutableSet<SoyType> flattenedMembers = UnionType.flatten(members);
        if (flattenedMembers.size() == 1) {
            return (SoyType)Iterables.getOnlyElement(flattenedMembers);
        }
        return new UnionType((Iterable<? extends SoyType>)flattenedMembers);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.UNION;
    }

    public Set<SoyType> getMembers() {
        return this.members;
    }

    @Override
    public boolean isAssignableFrom(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.UNION) {
            UnionType fromUnion = (UnionType)srcType;
            for (SoyType fromMember : fromUnion.members) {
                if (this.isAssignableFrom(fromMember)) continue;
                return false;
            }
            return true;
        }
        for (SoyType memberType : this.members) {
            if (!memberType.isAssignableFrom(srcType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        for (SoyType memberType : this.members) {
            if (!memberType.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isNullable() {
        return Iterables.any(this.members, IS_NULL);
    }

    public SoyType removeNullability() {
        if (this.isNullable()) {
            return UnionType.of(Collections2.filter(this.members, (Predicate)Predicates.not(IS_NULL)));
        }
        return this;
    }

    public String toString() {
        return Joiner.on((char)'|').join(this.members);
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((UnionType)other).members.equals(this.members);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.members);
    }

    private static ImmutableSet<SoyType> flatten(Collection<SoyType> members) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SoyType type : members) {
            if (type.getKind() == SoyType.Kind.UNKNOWN) {
                return ImmutableSet.of((Object)type);
            }
            if (type.getKind() == SoyType.Kind.UNION) {
                builder.addAll(((UnionType)type).members);
                continue;
            }
            builder.add((Object)type);
        }
        return builder.build();
    }
}

