/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class IfCondNode
extends AbstractBlockCommandNode
implements SoyNode.ConditionalBlockNode,
SoyNode.ExprHolderNode {
    private final ExprUnion exprUnion;

    public static Builder ifBuilder(int id, String commandText, SourceLocation sourceLocation) {
        return new Builder(id, "if", commandText, sourceLocation);
    }

    public static Builder elseifBuilder(int id, String commandText, SourceLocation sourceLocation) {
        return new Builder(id, "elseif", commandText, sourceLocation);
    }

    public IfCondNode(int id, SourceLocation sourceLocation, String commandName, ExprUnion exprUnion) {
        super(id, sourceLocation, commandName, exprUnion.getExprText());
        Preconditions.checkArgument((commandName.equals("if") || commandName.equals("elseif") ? 1 : 0) != 0);
        this.exprUnion = (ExprUnion)Preconditions.checkNotNull((Object)exprUnion);
    }

    private IfCondNode(IfCondNode orig, CopyState copyState) {
        super(orig, copyState);
        this.exprUnion = orig.exprUnion.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.IF_COND_NODE;
    }

    public String getExprText() {
        return this.exprUnion.getExprText();
    }

    public ExprUnion getExprUnion() {
        return this.exprUnion;
    }

    @Override
    public String getCommandName() {
        return this.getParent().getChild(0) == this ? "if" : "elseif";
    }

    @Override
    public String getCommandText() {
        return this.exprUnion.getExprText();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)this.exprUnion);
    }

    @Override
    public IfCondNode copy(CopyState copyState) {
        return new IfCondNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final String commandName;
        private final String commandText;
        private final SourceLocation sourceLocation;

        private Builder(int id, String commandName, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandName = commandName;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public IfCondNode build(SoyParsingContext context) {
            ExprUnion condition = ExprUnion.parseWithV1Fallback(this.commandText, this.sourceLocation, context);
            return new IfCondNode(this.id, this.sourceLocation, this.commandName, condition);
        }
    }
}

