/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoValue_ForNode_RangeArgs;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ForNode
extends AbstractBlockCommandNode
implements SoyNode.StandaloneNode,
SoyNode.StatementNode,
SoyNode.ConditionalBlockNode,
SoyNode.LoopNode,
SoyNode.ExprHolderNode,
SoyNode.LocalVarBlockNode {
    static final SoyErrorKind INVALID_COMMAND_TEXT = SoyErrorKind.of("Invalid ''for'' command text");
    private static final SoyErrorKind INVALID_RANGE_SPECIFICATION = SoyErrorKind.of("Invalid range specification");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("( [$] \\w+ ) \\s+ in \\s+ range[(] \\s* (.*) \\s* [)]", 36);
    private final LocalVar var;
    private final RangeArgs rangeArgs;

    public ForNode(int id, String commandText, SourceLocation sourceLocation, SoyParsingContext context) {
        super(id, sourceLocation, "for", commandText);
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(commandText);
        if (!matcher.matches()) {
            context.report(sourceLocation, INVALID_COMMAND_TEXT, new Object[0]);
            this.rangeArgs = RangeArgs.ERROR;
            this.var = new LocalVar("error", this, null);
            return;
        }
        String varName = ForNode.parseVarName(matcher.group(1), sourceLocation, context);
        List<ExprNode> rangeArgs = ForNode.parseRangeArgs(matcher.group(2), sourceLocation, context);
        if (rangeArgs.size() > 3) {
            context.report(sourceLocation, INVALID_RANGE_SPECIFICATION, new Object[0]);
            this.rangeArgs = RangeArgs.ERROR;
        } else if (rangeArgs.isEmpty()) {
            this.rangeArgs = RangeArgs.ERROR;
        } else {
            ExprNode start = rangeArgs.size() >= 2 ? rangeArgs.get(0) : null;
            ExprNode increment = rangeArgs.size() == 3 ? rangeArgs.get(2) : null;
            ExprNode limit = rangeArgs.get(rangeArgs.size() == 1 ? 0 : 1);
            this.rangeArgs = RangeArgs.create((Optional<ExprRootNode>)(start == null ? Optional.absent() : Optional.of((Object)new ExprRootNode(start))), new ExprRootNode(limit), (Optional<ExprRootNode>)(increment == null ? Optional.absent() : Optional.of((Object)new ExprRootNode(increment))));
        }
        this.var = new LocalVar(varName, this, null);
    }

    private static String parseVarName(String input, SourceLocation sourceLocation, SoyParsingContext context) {
        return new ExpressionParser(input, sourceLocation, context).parseVariable().getName();
    }

    private static List<ExprNode> parseRangeArgs(String input, SourceLocation sourceLocation, SoyParsingContext context) {
        return new ExpressionParser(input, sourceLocation, context).parseExpressionList();
    }

    private ForNode(ForNode orig, CopyState copyState) {
        super(orig, copyState);
        this.var = new LocalVar(orig.var, this);
        this.rangeArgs = orig.rangeArgs.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOR_NODE;
    }

    @Override
    public final LocalVar getVar() {
        return this.var;
    }

    @Override
    public final String getVarName() {
        return this.var.name();
    }

    public RangeArgs getRangeArgs() {
        return this.rangeArgs;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ExprUnion.createList((List<? extends ExprRootNode>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)this.rangeArgs.start().asSet(), (Iterable)ImmutableList.of((Object)this.rangeArgs.limit()), (Iterable)this.rangeArgs.increment().asSet())));
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public ForNode copy(CopyState copyState) {
        return new ForNode(this, copyState);
    }

    public static abstract class RangeArgs {
        static final RangeArgs ERROR = RangeArgs.create((Optional<ExprRootNode>)Optional.absent(), new ExprRootNode(VarRefNode.ERROR), (Optional<ExprRootNode>)Optional.absent());

        static RangeArgs create(Optional<ExprRootNode> start, ExprRootNode limit, Optional<ExprRootNode> increment) {
            return new AutoValue_ForNode_RangeArgs(start, limit, increment);
        }

        RangeArgs() {
        }

        public abstract Optional<ExprRootNode> start();

        public abstract ExprRootNode limit();

        public abstract Optional<ExprRootNode> increment();

        public final boolean definitelyNotEmpty() {
            int start = 0;
            if (this.start().isPresent()) {
                ExprRootNode startExpr = (ExprRootNode)this.start().get();
                if (startExpr.getRoot() instanceof IntegerNode) {
                    start = ((IntegerNode)startExpr.getRoot()).getValue();
                } else {
                    return false;
                }
            }
            if (!(this.limit().getRoot() instanceof IntegerNode)) {
                return false;
            }
            int limit = ((IntegerNode)this.limit().getRoot()).getValue();
            return start < limit;
        }

        private RangeArgs copy(CopyState copyState) {
            return RangeArgs.create((Optional<ExprRootNode>)(this.start().isPresent() ? Optional.of((Object)((ExprRootNode)this.start().get()).copy(copyState)) : Optional.absent()), this.limit().copy(copyState), (Optional<ExprRootNode>)(this.increment().isPresent() ? Optional.of((Object)((ExprRootNode)this.increment().get()).copy(copyState)) : Optional.absent()));
        }
    }
}

