/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class ResolveExpressionTypesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind BAD_FOREACH_TYPE = SoyErrorKind.of("cannot iterate over {0} of type {1}");
    private static final SoyErrorKind BAD_INDEX_TYPE = SoyErrorKind.of("bad index type {0} for {1}");
    private static final SoyErrorKind BAD_KEY_TYPE = SoyErrorKind.of("bad key type {0} for {1}");
    private static final SoyErrorKind EMPTY_LIST_FOREACH = SoyErrorKind.of("cannot iterate over empty list");
    private static final SoyErrorKind EMPTY_LIST_ACCESS = SoyErrorKind.of("accessing item in empty list");
    private static final SoyErrorKind EMPTY_MAP_ACCESS = SoyErrorKind.of("accessing item in empty map");
    private static final SoyErrorKind BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("type {0} does not support bracket access");
    private static final SoyErrorKind CHECK_NOT_NULL_ON_COMPILE_TIME_NULL = SoyErrorKind.of("Cannot call checkNotNull on a parameter with a static type of ''null''");
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("type {0} does not support dot access");
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD = SoyErrorKind.of("type {0} does not support dot access (consider record instead of map)");
    private static final SoyErrorKind DUPLICATE_KEY_IN_RECORD_LITERAL = SoyErrorKind.of("Record literals with duplicate keys are not allowed.  Duplicate key: ''{0}''");
    private static final SoyErrorKind LIST_LENGTH_ERROR = SoyErrorKind.of("Soy lists do not have a ''length'' field. Use function length(...) instead.");
    private static final SoyErrorKind MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for node {0}");
    private static final SoyErrorKind STRING_LENGTH_ERROR = SoyErrorKind.of("Soy strings do not have a ''length'' field. Use function strLen(...) instead.");
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_OBJECT_TYPE = SoyErrorKind.of("undefined field ''{0}'' for object type {1}");
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_RECORD_TYPE = SoyErrorKind.of("undefined field ''{0}'' for record type {1}");
    private static final SoyErrorKind VAR_REF_MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for variable");
    private final SyntaxVersion declaredSyntaxVersion;
    private final ErrorReporter errorReporter;
    private final SoyTypeOps typeOps;
    private TypeSubstitution substitutions;

    ResolveExpressionTypesVisitor(SoyTypeRegistry typeRegistry, SyntaxVersion declaredSyntaxVersion, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.typeOps = new SoyTypeOps(typeRegistry);
        this.declaredSyntaxVersion = declaredSyntaxVersion;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitSoyNode(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.visitSoyNode(node);
        ExprRootNode expr = node.getExprUnion().getExpr();
        if (expr != null && expr.getType().equals(BoolType.getInstance())) {
            String errorMsg = "Bool values can no longer be printed";
            if (this.declaredSyntaxVersion.num >= SyntaxVersion.V2_3.num && expr.getRoot() instanceof OperatorNodes.OrOpNode) {
                errorMsg = errorMsg + " (if you're intending the 'or' operator to return one of the operands instead of bool, please use the binary null-coalescing operator '?:' instead)";
            }
            errorMsg = errorMsg + ".";
            node.maybeSetSyntaxVersionUpperBound(new SyntaxVersionUpperBound(SyntaxVersion.V2_3, errorMsg));
        }
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.visitSoyNode(node);
        node.getVar().setType(node.getValueExpr().getType());
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitSoyNode(node);
        node.getVar().setType(node.getContentKind() != null ? SanitizedType.getTypeForContentKind(node.getContentKind()) : StringType.getInstance());
    }

    @Override
    protected void visitForNode(ForNode node) {
        this.visitExpressions(node);
        node.getVar().setType(IntType.getInstance());
        this.visitChildren(node);
    }

    @Override
    protected void visitIfNode(IfNode node) {
        TypeSubstitution savedSubstitutionState = this.substitutions;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                this.visitExpressions(icn);
                TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
                if (icn.getExprUnion().getExpr() != null) {
                    visitor.exec(icn.getExprUnion().getExpr());
                }
                TypeSubstitution previousSubstitutionState = this.substitutions;
                this.addTypeSubstitutions(visitor.positiveTypeConstraints);
                this.visitChildren(icn);
                this.substitutions = previousSubstitutionState;
                this.addTypeSubstitutions(visitor.negativeTypeConstraints);
                continue;
            }
            if (!(child instanceof IfElseNode)) continue;
            IfElseNode ien = (IfElseNode)child;
            this.visitChildren(ien);
        }
        this.substitutions = savedSubstitutionState;
    }

    private void addTypeSubstitutions(Map<Equivalence.Wrapper<ExprNode>, SoyType> substitutionsToAdd) {
        for (Map.Entry<Equivalence.Wrapper<ExprNode>, SoyType> entry : substitutionsToAdd.entrySet()) {
            ExprNode expr = (ExprNode)entry.getKey().get();
            SoyType previousType = expr.getType();
            TypeSubstitution subst = this.substitutions;
            while (subst != null) {
                if (ExprEquivalence.get().equivalent(subst.expression, expr)) {
                    previousType = subst.type;
                    break;
                }
                subst = subst.parent;
            }
            if (entry.getValue().equals(previousType)) continue;
            this.substitutions = new TypeSubstitution(this.substitutions, expr, entry.getValue());
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        this.visitExpressions(node.getParent());
        node.getVar().setType(this.getElementType(node.getExpr().getType(), node));
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ExprHolderNode) {
            this.visitExpressions((SoyNode.ExprHolderNode)node);
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        ResolveTypesExprVisitor exprVisitor = new ResolveTypesExprVisitor(node);
        for (ExprUnion exprUnion : node.getAllExprUnions()) {
            if (exprUnion.getExpr() == null) continue;
            exprVisitor.exec(exprUnion.getExpr());
        }
    }

    private SoyType getElementType(SoyType collectionType, ForeachNonemptyNode node) {
        Preconditions.checkNotNull((Object)collectionType);
        switch (collectionType.getKind()) {
            case UNKNOWN: {
                return UnknownType.getInstance();
            }
            case LIST: {
                if (collectionType == ListType.EMPTY_LIST) {
                    this.errorReporter.report(node.getParent().getSourceLocation(), EMPTY_LIST_FOREACH, new Object[0]);
                    return ErrorType.getInstance();
                }
                return ((ListType)collectionType).getElementType();
            }
            case UNION: {
                UnionType unionType = (UnionType)collectionType;
                ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                for (SoyType unionMember : unionType.getMembers()) {
                    SoyType elementType = this.getElementType(unionMember, node);
                    if (elementType.getKind() == SoyType.Kind.ERROR) {
                        return ErrorType.getInstance();
                    }
                    fieldTypes.add(elementType);
                }
                return this.typeOps.computeLowestCommonType(fieldTypes);
            }
        }
        this.errorReporter.report(node.getParent().getSourceLocation(), BAD_FOREACH_TYPE, node.getExpr().toSourceString(), node.getExpr().getType());
        return ErrorType.getInstance();
    }

    private static final class TypeSubstitution {
        @Nullable
        final TypeSubstitution parent;
        final ExprNode expression;
        final SoyType type;

        TypeSubstitution(@Nullable TypeSubstitution parent, ExprNode expression, SoyType type) {
            this.parent = parent;
            this.expression = expression;
            this.type = type;
        }
    }

    private final class TypeNarrowingConditionVisitor
    extends AbstractExprNodeVisitor<Void> {
        Map<Equivalence.Wrapper<ExprNode>, SoyType> positiveTypeConstraints = new LinkedHashMap<Equivalence.Wrapper<ExprNode>, SoyType>();
        Map<Equivalence.Wrapper<ExprNode>, SoyType> negativeTypeConstraints = new LinkedHashMap<Equivalence.Wrapper<ExprNode>, SoyType>();

        private TypeNarrowingConditionVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitAndImplicitlyCastToBoolean(node.getRoot());
        }

        void visitAndImplicitlyCastToBoolean(ExprNode node) {
            this.visit(node);
            Equivalence.Wrapper wrapped = ExprEquivalence.get().wrap(node);
            this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrapped, SoyTypes.removeNull(node.getType()));
            this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrapped, node.getType());
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            Preconditions.checkArgument((node.getChildren().size() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.positiveTypeConstraints.putAll(this.computeConstraintUnion(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints));
            this.negativeTypeConstraints.putAll(this.computeConstraintIntersection(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints));
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            Preconditions.checkArgument((node.getChildren().size() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.positiveTypeConstraints.putAll(this.computeConstraintIntersection(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints));
            this.negativeTypeConstraints.putAll(this.computeConstraintUnion(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints));
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            TypeNarrowingConditionVisitor childVisitor = new TypeNarrowingConditionVisitor();
            childVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            this.positiveTypeConstraints.putAll(childVisitor.negativeTypeConstraints);
            this.negativeTypeConstraints.putAll(childVisitor.positiveTypeConstraints);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.removeNull(((ExprNode)wrappedExpr.get()).getType()));
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(1));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.removeNull(((ExprNode)wrappedExpr.get()).getType()));
            }
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.removeNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(1));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.removeNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            }
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.numChildren() != 1) {
                return;
            }
            if (node.getFunctionName().equals("isNonnull")) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.removeNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            } else if (node.getFunctionName().equals("isNull")) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.removeNull(((ExprNode)wrappedExpr.get()).getType()));
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        private <T> Map<T, SoyType> computeConstraintUnion(Map<T, SoyType> left, Map<T, SoyType> right) {
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
            LinkedHashMap<T, SoyType> result = new LinkedHashMap<T, SoyType>(left);
            for (Map.Entry<T, SoyType> entry : right.entrySet()) {
                if (left.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        private Map<Equivalence.Wrapper<ExprNode>, SoyType> computeConstraintIntersection(Map<Equivalence.Wrapper<ExprNode>, SoyType> left, Map<Equivalence.Wrapper<ExprNode>, SoyType> right) {
            if (left.isEmpty()) {
                return left;
            }
            if (right.isEmpty()) {
                return right;
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)left.size());
            for (Map.Entry<Equivalence.Wrapper<ExprNode>, SoyType> entry : left.entrySet()) {
                if (!right.containsKey(entry.getKey())) continue;
                SoyType rightSideType = right.get(entry.getKey());
                result.put(entry.getKey(), ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(entry.getValue(), rightSideType));
            }
            return result;
        }
    }

    private final class ResolveTypesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final AbstractExprNodeVisitor<Void> checkAllTypesAssignedVisitor = new AbstractExprNodeVisitor<Void>(){

            @Override
            protected void visitExprNode(ExprNode node) {
                if (node instanceof ExprNode.ParentExprNode) {
                    this.visitChildren((ExprNode.ParentExprNode)node);
                }
                ResolveTypesExprVisitor.this.requireNodeType(node);
            }
        };
        private final SoyNode.ExprHolderNode owningSoyNode;

        ResolveTypesExprVisitor(SoyNode.ExprHolderNode owningSoyNode) {
            this.owningSoyNode = owningSoyNode;
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            this.checkAllTypesAssignedVisitor.exec(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
            ExprNode expr = node.getRoot();
            node.setType(expr.getType());
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
            ArrayList<SoyType> elementTypes = new ArrayList<SoyType>(node.getChildren().size());
            for (ExprNode child : node.getChildren()) {
                this.requireNodeType(child);
                elementTypes.add(child.getType());
            }
            if (elementTypes.isEmpty()) {
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesVisitor.this.typeOps.getTypeRegistry().getOrCreateListType(ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(elementTypes)));
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
            this.setMapLiteralNodeType(node);
            this.tryApplySubstitution(node);
        }

        private void setMapLiteralNodeType(MapLiteralNode node) {
            int numChildren = node.numChildren();
            if (numChildren % 2 != 0) {
                throw new AssertionError();
            }
            if (numChildren == 0) {
                node.setType(MapType.EMPTY_MAP);
                return;
            }
            HashSet<String> duplicateKeyErrors = new HashSet<String>();
            LinkedHashMap<String, SoyType> recordFieldTypes = new LinkedHashMap<String, SoyType>();
            ArrayList<SoyType> keyTypes = new ArrayList<SoyType>(numChildren / 2);
            ArrayList<SoyType> valueTypes = new ArrayList<SoyType>(numChildren / 2);
            for (int i = 0; i < numChildren; i += 2) {
                String fieldName;
                SoyType prev;
                ExprNode key = node.getChild(i);
                ExprNode value = node.getChild(i + 1);
                if (key.getKind() == ExprNode.Kind.STRING_NODE && (prev = recordFieldTypes.put(fieldName = ((StringNode)key).getValue(), value.getType())) != null && duplicateKeyErrors.add(fieldName)) {
                    ResolveExpressionTypesVisitor.this.errorReporter.report(this.owningSoyNode.getSourceLocation(), DUPLICATE_KEY_IN_RECORD_LITERAL, fieldName);
                }
                keyTypes.add(key.getType());
                valueTypes.add(value.getType());
            }
            SoyType commonKeyType = ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(keyTypes);
            SoyType commonValueType = ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(valueTypes);
            if (StringType.getInstance().isAssignableFrom(commonKeyType) && recordFieldTypes.size() == numChildren / 2) {
                HashMap leastCommonFieldTypes = Maps.newHashMapWithExpectedSize((int)recordFieldTypes.size());
                for (String fieldName : recordFieldTypes.keySet()) {
                    leastCommonFieldTypes.put(fieldName, recordFieldTypes.get(fieldName));
                }
                node.setType(ResolveExpressionTypesVisitor.this.typeOps.getTypeRegistry().getOrCreateRecordType(leastCommonFieldTypes));
            } else {
                node.setType(ResolveExpressionTypesVisitor.this.typeOps.getTypeRegistry().getOrCreateMapType(commonKeyType, commonValueType));
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            SoyType newType;
            if (varRef.getType() == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(varRef.getSourceLocation(), VAR_REF_MISSING_SOY_TYPE, new Object[0]);
            }
            if ((newType = this.getTypeSubstitution(varRef)) != null) {
                varRef.setSubstituteType(newType);
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            this.visit(node.getBaseExprChild());
            node.setType(this.getFieldType(node.getBaseExprChild().getType(), node.getFieldName(), node.isNullSafe(), node.getSourceLocation()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitItemAccessNode(ItemAccessNode node) {
            this.visit(node.getBaseExprChild());
            this.visit(node.getKeyExprChild());
            SoyType itemType = this.getItemType(node.getBaseExprChild().getType(), node.getKeyExprChild().getType(), node.getSourceLocation());
            node.setType(itemType);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
        }

        @Override
        protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            this.visitChildren(node);
            SoyType childType = node.getChild(0).getType();
            if (ResolveExpressionTypesVisitor.this.typeOps.isNumericOrUnknown(childType)) {
                node.setType(childType);
            } else {
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            this.visitChildren(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            if (ResolveExpressionTypesVisitor.this.typeOps.isNumericOrUnknown(left) && ResolveExpressionTypesVisitor.this.typeOps.isNumericOrUnknown(right)) {
                node.setType(FloatType.getInstance());
            } else {
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitModOpNode(OperatorNodes.ModOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            Optional<SoyType> arithmeticType = ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonTypeArithmetic(left, right);
            if (arithmeticType.isPresent()) {
                node.setType((SoyType)arithmeticType.get());
            } else if (StringType.getInstance().isAssignableFrom(left) || StringType.getInstance().isAssignableFrom(right)) {
                node.setType(StringType.getInstance());
            } else {
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            this.markLogicalOpType(node);
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            this.markLogicalOpType(node);
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            node.setType(ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(node.getChild(0).getType(), node.getChild(1).getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(2));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            node.setType(ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(node.getChild(1).getType(), node.getChild(2).getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            this.visitChildren(node);
            SoyFunction knownFunction = node.getSoyFunction();
            if (knownFunction instanceof BuiltinFunction) {
                switch ((BuiltinFunction)knownFunction) {
                    case CHECK_NOT_NULL: {
                        SoyType type = node.getChild(0).getType();
                        if (type.equals(NullType.getInstance())) {
                            ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, new Object[0]);
                            break;
                        }
                        node.setType(SoyTypes.removeNull(type));
                        break;
                    }
                    case INDEX: {
                        node.setType(IntType.getInstance());
                        break;
                    }
                    case IS_FIRST: 
                    case IS_LAST: {
                        node.setType(BoolType.getInstance());
                        break;
                    }
                    case QUOTE_KEYS_IF_JS: {
                        node.setType(UnknownType.getInstance());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            } else {
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        private void markLogicalOpType(AbstractOperatorNode node) {
            if (((ResolveExpressionTypesVisitor)ResolveExpressionTypesVisitor.this).declaredSyntaxVersion.num >= SyntaxVersion.V2_3.num) {
                node.setType(BoolType.getInstance());
            } else {
                node.setType(UnknownType.getInstance());
            }
        }

        private void visitComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            node.setType(BoolType.getInstance());
        }

        private void visitArithmeticOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            Optional<SoyType> arithmeticType = ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonTypeArithmetic(left, right);
            if (arithmeticType.isPresent()) {
                node.setType((SoyType)arithmeticType.get());
            } else {
                node.setType(SoyTypes.NUMBER_TYPE);
            }
            this.tryApplySubstitution(node);
        }

        private void requireNodeType(ExprNode node) {
            if (node.getType() == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), MISSING_SOY_TYPE, node.getClass().getName());
            }
        }

        private SoyType getFieldType(SoyType baseType, String fieldName, boolean isNullSafe, SourceLocation sourceLocation) {
            Preconditions.checkNotNull((Object)baseType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case OBJECT: {
                    SoyObjectType objectType = (SoyObjectType)baseType;
                    SoyType fieldType = objectType.getFieldType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = "";
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_OBJECT_TYPE, fieldName, baseType + extraErrorMessage);
                    return ErrorType.getInstance();
                }
                case STRING: 
                case CSS: 
                case JS: 
                case ATTRIBUTES: 
                case HTML: 
                case URI: {
                    if (!fieldName.equals("length")) break;
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, STRING_LENGTH_ERROR, new Object[0]);
                    return ErrorType.getInstance();
                }
                case LIST: {
                    if (!fieldName.equals("length")) break;
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, LIST_LENGTH_ERROR, new Object[0]);
                    return ErrorType.getInstance();
                }
                case RECORD: {
                    SoyType fieldType = ((SoyObjectType)baseType).getFieldType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_RECORD_TYPE, fieldName, baseType);
                    return ErrorType.getInstance();
                }
                case MAP: {
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD, baseType);
                    return ErrorType.getInstance();
                }
                case UNION: {
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.getKind() == SoyType.Kind.NULL) continue;
                        SoyType fieldType = this.getFieldType(unionMember, fieldName, isNullSafe, sourceLocation);
                        if (fieldType == ErrorType.getInstance()) {
                            return fieldType;
                        }
                        fieldTypes.add(fieldType);
                    }
                    return ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(fieldTypes);
                }
            }
            ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED, baseType);
            return ErrorType.getInstance();
        }

        private SoyType getItemType(SoyType baseType, SoyType keyType, SourceLocation sourceLocation) {
            Preconditions.checkNotNull((Object)baseType);
            Preconditions.checkNotNull((Object)keyType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case LIST: {
                    ListType listType = (ListType)baseType;
                    if (listType == ListType.EMPTY_LIST) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, EMPTY_LIST_ACCESS, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    if (keyType.getKind() != SoyType.Kind.UNKNOWN && !IntType.getInstance().isAssignableFrom(keyType)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, BAD_INDEX_TYPE, keyType, baseType);
                        return ErrorType.getInstance();
                    }
                    return listType.getElementType();
                }
                case MAP: {
                    MapType mapType = (MapType)baseType;
                    if (mapType == MapType.EMPTY_MAP) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, EMPTY_MAP_ACCESS, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    if (keyType.getKind() != SoyType.Kind.UNKNOWN && !mapType.getKeyType().isAssignableFrom(keyType)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, BAD_KEY_TYPE, keyType, baseType);
                        return ErrorType.getInstance();
                    }
                    return mapType.getValueType();
                }
                case UNION: {
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> itemTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        SoyType itemType = this.getItemType(unionMember, keyType, sourceLocation);
                        if (itemType == ErrorType.getInstance()) {
                            return itemType;
                        }
                        itemTypes.add(itemType);
                    }
                    return ResolveExpressionTypesVisitor.this.typeOps.computeLowestCommonType(itemTypes);
                }
            }
            ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, BRACKET_ACCESS_NOT_SUPPORTED, baseType);
            return ErrorType.getInstance();
        }

        private void tryApplySubstitution(AbstractParentExprNode parentNode) {
            SoyType newType = this.getTypeSubstitution(parentNode);
            if (newType != null) {
                Preconditions.checkState((boolean)parentNode.getType().isAssignableFrom(newType), (String)"Tried to override '%s' with '%s'", (Object[])new Object[]{parentNode.getType(), newType});
                parentNode.setType(newType);
            }
        }

        @Nullable
        private SoyType getTypeSubstitution(ExprNode expr) {
            TypeSubstitution subst = ResolveExpressionTypesVisitor.this.substitutions;
            while (subst != null) {
                if (ExprEquivalence.get().equivalent(subst.expression, expr)) {
                    return subst.type;
                }
                subst = subst.parent;
            }
            return null;
        }
    }
}

