/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;

final class UniqueNameGenerator {
    private static final CharMatcher DANGEROUS_CHARACTERS = CharMatcher.anyOf((CharSequence)"/.;<<>[]:\\%").precomputed();
    private static final CharMatcher DANGEROUS_CHARACTERS_WITH_DOLLARSIGN = DANGEROUS_CHARACTERS.or(CharMatcher.anyOf((CharSequence)"$")).precomputed();
    private final Multiset<String> names = HashMultiset.create();
    private final CharMatcher bannedCharacters;
    private final char collisionSeparator;

    static UniqueNameGenerator forFieldNames() {
        return new UniqueNameGenerator(DANGEROUS_CHARACTERS, '%');
    }

    static UniqueNameGenerator forClassNames() {
        return new UniqueNameGenerator(DANGEROUS_CHARACTERS_WITH_DOLLARSIGN, '\u2169');
    }

    private UniqueNameGenerator(CharMatcher bannedCharacters, char collisionSeparator) {
        this.bannedCharacters = bannedCharacters;
        this.collisionSeparator = collisionSeparator;
    }

    void claimName(String name) {
        this.checkName(name);
        if (this.names.contains((Object)name)) {
            throw new IllegalArgumentException("Name: " + name + " was already claimed!");
        }
        this.names.add((Object)name);
    }

    String generateName(String name) {
        this.checkName(name);
        this.names.add((Object)name);
        int count = this.names.count((Object)name);
        if (count == 1) {
            return name;
        }
        return name + this.collisionSeparator + (count - 1);
    }

    boolean hasName(String name) {
        int separator = name.indexOf(this.collisionSeparator);
        return this.names.contains((Object)(separator == -1 ? name : name.substring(0, separator)));
    }

    private void checkName(String name) {
        Preconditions.checkArgument((!this.bannedCharacters.matchesAnyOf((CharSequence)name) ? 1 : 0) != 0, (String)"%s contains dangerous characters!", (Object[])new Object[]{name});
    }
}

