/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.proto.SoyProtoEnumTypeImpl;
import com.google.template.soy.types.proto.SoyProtoTypeImpl;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

abstract class SoyRuntimeType {
    private static final ImmutableSet<SoyType.Kind> STRING_KINDS = Sets.immutableEnumSet((Enum)SoyType.Kind.STRING, (Enum[])new SoyType.Kind[]{SoyType.Kind.HTML, SoyType.Kind.ATTRIBUTES, SoyType.Kind.JS, SoyType.Kind.CSS, SoyType.Kind.URI, SoyType.Kind.TRUSTED_RESOURCE_URI});
    private static final LoadingCache<SoyType, Optional<PrimitiveSoyType>> primitiveTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SoyType, Optional<PrimitiveSoyType>>(){

        public Optional<PrimitiveSoyType> load(SoyType key) throws Exception {
            return Optional.fromNullable((Object)SoyRuntimeType.unboxedTypeImpl(key));
        }
    });
    private static final LoadingCache<SoyType, BoxedSoyType> boxedTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SoyType, BoxedSoyType>(){

        public BoxedSoyType load(SoyType key) throws Exception {
            return SoyRuntimeType.boxedSoyTypeImpl(key);
        }
    });
    private final SoyType soyType;
    private final Type runtimeType;

    static Optional<SoyRuntimeType> getUnboxedType(SoyType soyType) {
        Optional typed = (Optional)primitiveTypeCache.getUnchecked((Object)soyType);
        return typed;
    }

    static SoyRuntimeType getBoxedType(SoyType soyType) {
        return (SoyRuntimeType)boxedTypeCache.getUnchecked((Object)soyType);
    }

    @Nullable
    private static BoxedSoyType boxedSoyTypeImpl(SoyType soyType) {
        Optional primitive = (Optional)primitiveTypeCache.getUnchecked((Object)soyType);
        if (primitive.isPresent()) {
            return ((PrimitiveSoyType)primitive.get()).box();
        }
        switch (soyType.getKind()) {
            case LIST: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_LIST_TYPE);
            }
            case MAP: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_MAP_TYPE);
            }
            case RECORD: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_RECORD_TYPE);
            }
            case UNION: {
                SoyType nonNullType = ((UnionType)soyType).removeNullability();
                if (nonNullType != soyType) {
                    BoxedSoyType boxedType = SoyRuntimeType.boxedSoyTypeImpl(nonNullType);
                    return new BoxedSoyType(soyType, boxedType.runtimeType());
                }
            }
            case UNKNOWN: 
            case ANY: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_VALUE_TYPE);
            }
        }
        throw new AssertionError((Object)("can't map " + soyType + " to a boxed soy runtime type"));
    }

    @Nullable
    private static PrimitiveSoyType unboxedTypeImpl(SoyType soyType) {
        switch (soyType.getKind()) {
            case NULL: {
                return new PrimitiveSoyType((SoyType)NullType.getInstance(), BytecodeUtils.OBJECT.type(), Type.getType(NullData.class));
            }
            case BOOL: {
                return new PrimitiveSoyType((SoyType)BoolType.getInstance(), Type.BOOLEAN_TYPE, Type.getType(BooleanData.class));
            }
            case STRING: {
                return new PrimitiveSoyType((SoyType)StringType.getInstance(), BytecodeUtils.STRING_TYPE, Type.getType(SoyString.class));
            }
            case INT: {
                return new PrimitiveSoyType((SoyType)IntType.getInstance(), Type.LONG_TYPE, BytecodeUtils.INTEGER_DATA_TYPE);
            }
            case FLOAT: {
                return new PrimitiveSoyType((SoyType)FloatType.getInstance(), Type.DOUBLE_TYPE, Type.getType(FloatData.class));
            }
            case ENUM: {
                return SoyRuntimeType.enumType((SoyProtoEnumTypeImpl)soyType);
            }
            case ATTRIBUTES: 
            case CSS: 
            case URI: 
            case HTML: 
            case JS: 
            case TRUSTED_RESOURCE_URI: {
                return SoyRuntimeType.sanitizedType((SanitizedType)soyType);
            }
            case OBJECT: {
                return SoyRuntimeType.protoType((SoyProtoTypeImpl)soyType);
            }
            case LIST: {
                return new PrimitiveSoyType(soyType, BytecodeUtils.LIST_TYPE, BytecodeUtils.SOY_LIST_TYPE);
            }
            case MAP: 
            case RECORD: {
                return null;
            }
            case UNION: {
                PrimitiveSoyType primitive;
                SoyType nonNullType = ((UnionType)soyType).removeNullability();
                if (nonNullType != soyType && (primitive = SoyRuntimeType.unboxedTypeImpl(nonNullType)) != null && !BytecodeUtils.isPrimitive(primitive.runtimeType())) {
                    return new PrimitiveSoyType(soyType, primitive.runtimeType(), primitive.box().runtimeType());
                }
            }
            case UNKNOWN: 
            case ANY: {
                return null;
            }
        }
        throw new AssertionError((Object)("can't map " + soyType + " to an unboxed soy runtime type"));
    }

    private static PrimitiveSoyType protoType(SoyProtoTypeImpl soyType) {
        return new PrimitiveSoyType((SoyType)soyType, Type.getType((String)('L' + soyType.getNameForBackend(SoyBackendKind.JBC_SRC).replace('.', '/') + ';')), BytecodeUtils.PROTO_VALUE_TYPE);
    }

    private static PrimitiveSoyType sanitizedType(SanitizedType soyType) {
        return new PrimitiveSoyType((SoyType)soyType, BytecodeUtils.STRING_TYPE, Type.getType(SanitizedContent.class));
    }

    private static PrimitiveSoyType enumType(SoyProtoEnumTypeImpl enumType) {
        return new PrimitiveSoyType((SoyType)enumType, Type.INT_TYPE, BytecodeUtils.INTEGER_DATA_TYPE);
    }

    private SoyRuntimeType(SoyType soyType, Type runtimeType) {
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)soyType);
        this.runtimeType = (Type)Preconditions.checkNotNull((Object)runtimeType);
    }

    final SoyType soyType() {
        return this.soyType;
    }

    final Type runtimeType() {
        return this.runtimeType;
    }

    boolean isKnownString() {
        return this.soyType.getKind() == SoyType.Kind.STRING;
    }

    boolean isKnownStringOrSanitizedContent() {
        return STRING_KINDS.contains((Object)this.soyType.getKind());
    }

    boolean isKnownSanitizedContent() {
        return this.soyType.getKind() != SoyType.Kind.STRING && STRING_KINDS.contains((Object)this.soyType.getKind());
    }

    boolean isKnownInt() {
        return this.soyType.getKind() == SoyType.Kind.INT;
    }

    boolean assignableToNullableInt() {
        return this.assignableToNullableType(IntType.getInstance());
    }

    boolean assignableToNullableFloat() {
        return this.assignableToNullableType(FloatType.getInstance());
    }

    boolean assignableToNullableNumber() {
        return this.assignableToNullableType(SoyTypes.NUMBER_TYPE);
    }

    private boolean assignableToNullableType(SoyType type) {
        return type.isAssignableFrom(this.soyType) || this.soyType.getKind() == SoyType.Kind.UNION && type.isAssignableFrom(SoyTypes.removeNull(this.soyType));
    }

    final boolean isKnownFloat() {
        return this.soyType.getKind() == SoyType.Kind.FLOAT;
    }

    final boolean isKnownList() {
        return this.soyType.getKind() == SoyType.Kind.LIST;
    }

    final boolean isKnownMap() {
        return this.soyType.getKind() == SoyType.Kind.MAP;
    }

    final boolean isKnownRecord() {
        return this.soyType.getKind() == SoyType.Kind.RECORD;
    }

    final boolean isKnownBool() {
        return this.soyType.getKind() == SoyType.Kind.BOOL;
    }

    final boolean isKnownProto() {
        return this.soyType instanceof SoyProtoTypeImpl;
    }

    final boolean isKnownNumber() {
        return SoyTypes.NUMBER_TYPE.isAssignableFrom(this.soyType);
    }

    final SoyRuntimeType asNonNullable() {
        return this.withNewSoyType(SoyTypes.removeNull(this.soyType));
    }

    final SoyRuntimeType asNullable() {
        return this.withNewSoyType(SoyTypes.makeNullable(this.soyType));
    }

    private SoyRuntimeType withNewSoyType(SoyType newSoyType) {
        if (newSoyType != this.soyType) {
            if (this.isBoxed()) {
                return SoyRuntimeType.getBoxedType(newSoyType);
            }
            return (SoyRuntimeType)SoyRuntimeType.getUnboxedType(newSoyType).get();
        }
        return this;
    }

    abstract boolean isBoxed();

    abstract SoyRuntimeType box();

    public String toString() {
        return "SoyRuntimeType{" + this.soyType + ", " + this.runtimeType + "}";
    }

    private static final class BoxedSoyType
    extends SoyRuntimeType {
        BoxedSoyType(SoyType soyType, Type runtimeType) {
            super(soyType, runtimeType);
        }

        @Override
        public boolean isBoxed() {
            return true;
        }

        @Override
        SoyRuntimeType box() {
            return this;
        }
    }

    private static final class PrimitiveSoyType
    extends SoyRuntimeType {
        private final BoxedSoyType boxedType;

        PrimitiveSoyType(SoyType soyType, Type runtimeType, Type boxedType) {
            super(soyType, runtimeType);
            this.boxedType = new BoxedSoyType(soyType, boxedType);
        }

        @Override
        public boolean isBoxed() {
            return false;
        }

        @Override
        BoxedSoyType box() {
            return this.boxedType;
        }
    }
}

