/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.BytecodeUtils;
import com.google.template.soy.jbcsrc.CodeBuilder;
import com.google.template.soy.jbcsrc.Expression;
import com.google.template.soy.jbcsrc.FieldRef;
import com.google.template.soy.jbcsrc.MethodRef;
import com.google.template.soy.jbcsrc.ProtoUtils;
import com.google.template.soy.jbcsrc.SoyRuntimeType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class SoyExpression
extends Expression {
    static final SoyExpression NULL = new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(NullType.getInstance()), new Expression(BytecodeUtils.OBJECT.type(), Expression.Feature.CHEAP, new Expression.Feature[0]){

        @Override
        void doGen(CodeBuilder adapter) {
            adapter.visitInsn(1);
        }
    });
    static final SoyExpression TRUE = new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(BoolType.getInstance()), BytecodeUtils.constant(true)){

        @Override
        SoyExpression box() {
            return new DefaultBoxed(SoyRuntimeType.getBoxedType(BoolType.getInstance()), this, FieldRef.BOOLEAN_DATA_TRUE.accessor(), (Optional<Expression>)Optional.absent());
        }
    };
    static final SoyExpression FALSE = new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(BoolType.getInstance()), BytecodeUtils.constant(false)){

        @Override
        SoyExpression box() {
            return new DefaultBoxed(SoyRuntimeType.getBoxedType(BoolType.getInstance()), this, FieldRef.BOOLEAN_DATA_FALSE.accessor(), (Optional<Expression>)Optional.absent());
        }
    };
    private final SoyRuntimeType soyType;
    private final Expression delegate;
    private final Optional<Expression> renderContext;

    static SoyExpression forSoyValue(SoyType type, Expression delegate) {
        return new SoyExpression(SoyRuntimeType.getBoxedType(type), delegate, (Optional<Expression>)Optional.absent());
    }

    static SoyExpression forBool(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(BoolType.getInstance()), delegate);
    }

    static SoyExpression forFloat(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(FloatType.getInstance()), delegate);
    }

    static SoyExpression forInt(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(IntType.getInstance()), delegate);
    }

    static SoyExpression forString(Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(StringType.getInstance()), delegate);
    }

    static SoyExpression forSanitizedString(Expression delegate, SanitizedContent.ContentKind kind) {
        return new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(SanitizedType.getTypeForContentKind(kind)), delegate);
    }

    static SoyExpression forList(ListType listType, Expression delegate) {
        return new SoyExpression(SoyExpression.getUnboxedTypeUnchecked(listType), delegate);
    }

    static SoyExpression forProto(SoyRuntimeType type, Expression delegate, Expression renderContext) {
        Preconditions.checkArgument((boolean)renderContext.resultType().equals((Object)BytecodeUtils.RENDER_CONTEXT_TYPE));
        return new SoyExpression(type, delegate, (Optional<Expression>)Optional.of((Object)renderContext));
    }

    static Expression asBoxedList(List<SoyExpression> items) {
        ArrayList<SoyExpression> childExprs = new ArrayList<SoyExpression>(items.size());
        for (SoyExpression child : items) {
            childExprs.add(child.box());
        }
        return BytecodeUtils.asList(childExprs);
    }

    private static SoyRuntimeType getUnboxedTypeUnchecked(SoyType soyType) {
        return (SoyRuntimeType)SoyRuntimeType.getUnboxedType(soyType).get();
    }

    private SoyExpression(SoyRuntimeType soyType, Expression delegate) {
        this(soyType, delegate, (Optional<Expression>)Optional.absent());
    }

    private SoyExpression(SoyRuntimeType soyType, Expression delegate, Optional<Expression> renderContext) {
        super(delegate.resultType(), delegate.features());
        Preconditions.checkArgument((boolean)BytecodeUtils.isPossiblyAssignableFrom(soyType.runtimeType(), delegate.resultType()), (String)"delegate with type %s isn't compatible with asserted SoyExpression type %s", (Object[])new Object[]{delegate.resultType(), soyType.runtimeType()});
        this.soyType = soyType;
        this.delegate = delegate;
        this.renderContext = renderContext;
    }

    final SoyType soyType() {
        return this.soyRuntimeType().soyType();
    }

    final SoyRuntimeType soyRuntimeType() {
        return this.soyType;
    }

    @Override
    final void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    boolean assignableToNullableInt() {
        return this.soyRuntimeType().assignableToNullableInt();
    }

    boolean assignableToNullableFloat() {
        return this.soyRuntimeType().assignableToNullableFloat();
    }

    boolean assignableToNullableNumber() {
        return this.soyRuntimeType().assignableToNullableNumber();
    }

    boolean isKnownList() {
        return this.soyRuntimeType().isKnownList();
    }

    boolean isBoxed() {
        return this.soyRuntimeType().isBoxed();
    }

    SoyExpression box() {
        if (this.isBoxed()) {
            return this;
        }
        if (this.soyType.soyType().equals(NullType.getInstance())) {
            return this;
        }
        if (!this.delegate.isNonNullable()) {
            final Label end = new Label();
            return this.withSource(new Expression(this.resultType(), this.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    SoyExpression.this.delegate.gen(adapter);
                    BytecodeUtils.nullCoalesce(adapter, end);
                }
            }).asNonNullable().box().asNullable().labelEnd(end);
        }
        if (this.soyRuntimeType().isKnownBool()) {
            return this.asBoxed(MethodRef.BOOLEAN_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType().isKnownInt()) {
            return this.asBoxed(MethodRef.INTEGER_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType().isKnownFloat()) {
            return this.asBoxed(MethodRef.FLOAT_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.soyRuntimeType().isKnownSanitizedContent()) {
            return this.asBoxed(MethodRef.ORDAIN_AS_SAFE.invoke(this.delegate, FieldRef.enumReference(((SanitizedType)this.soyRuntimeType().soyType()).getContentKind()).accessor()));
        }
        if (this.soyRuntimeType().isKnownString()) {
            return this.asBoxed(MethodRef.STRING_DATA_FOR_VALUE.invoke(this.delegate));
        }
        if (this.isKnownList()) {
            return this.asBoxed(MethodRef.LIST_IMPL_FOR_PROVIDER_LIST.invoke(this.delegate));
        }
        if (this.soyRuntimeType().isKnownProto()) {
            final Expression context = (Expression)this.renderContext.get();
            return this.asBoxed(new Expression(ProtoUtils.RENDER_CONTEXT_BOX.returnType(), this.delegate.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    SoyExpression.this.delegate.gen(adapter);
                    context.gen(adapter);
                    adapter.swap();
                    ProtoUtils.RENDER_CONTEXT_BOX.invokeUnchecked(adapter);
                }
            });
        }
        throw new IllegalStateException("cannot box soy expression of type " + this.soyType);
    }

    private DefaultBoxed asBoxed(Expression expr) {
        return new DefaultBoxed(this.soyRuntimeType().box(), this, expr, this.renderContext);
    }

    SoyExpression coerceToBoolean() {
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            return this.coercePrimitiveToBoolean();
        }
        if (this.soyType.soyType().equals(NullType.getInstance())) {
            return FALSE;
        }
        if (this.delegate.isNonNullable()) {
            return this.coerceNonNullableReferenceTypeToBoolean();
        }
        final Label end = new Label();
        return this.withSource(new Expression(this.delegate.resultType(), this.delegate.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                SoyExpression.this.delegate.gen(adapter);
                adapter.dup();
                Label nonNull = new Label();
                adapter.ifNonNull(nonNull);
                adapter.pop();
                adapter.pushBoolean(false);
                adapter.goTo(end);
                adapter.mark(nonNull);
            }
        }).asNonNullable().coerceToBoolean().labelEnd(end);
    }

    private SoyExpression coercePrimitiveToBoolean() {
        if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
            return this;
        }
        if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
            return SoyExpression.forBool(MethodRef.RUNTIME_COERCE_DOUBLE_TO_BOOLEAN.invoke(this.delegate));
        }
        if (this.resultType().equals((Object)Type.LONG_TYPE)) {
            return SoyExpression.forBool(BytecodeUtils.compare(154, this.delegate, BytecodeUtils.constant(0L)));
        }
        throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
    }

    private SoyExpression coerceNonNullableReferenceTypeToBoolean() {
        if (this.isBoxed()) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_COERCE_TO_BOOLEAN, new Expression[0]));
        }
        if (this.soyRuntimeType().isKnownString()) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(this.delegate.invoke(MethodRef.STRING_IS_EMPTY, new Expression[0])));
        }
        return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE, this.delegate.features()){

            @Override
            void doGen(CodeBuilder adapter) {
                SoyExpression.this.delegate.gen(adapter);
                adapter.pop();
                adapter.pushBoolean(true);
            }
        });
    }

    SoyExpression coerceToString() {
        if (this.soyRuntimeType().isKnownString() && !this.isBoxed()) {
            return this;
        }
        if (BytecodeUtils.isPrimitive(this.resultType())) {
            if (this.resultType().equals((Object)Type.BOOLEAN_TYPE)) {
                return SoyExpression.forString(MethodRef.BOOLEAN_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.DOUBLE_TYPE)) {
                return SoyExpression.forString(MethodRef.DOUBLE_TO_STRING.invoke(this.delegate));
            }
            if (this.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(this.delegate));
            }
            throw new AssertionError((Object)("resultType(): " + this.resultType() + " is not a valid type for a SoyExpression"));
        }
        if (!this.isBoxed()) {
            return SoyExpression.forString(MethodRef.STRING_VALUE_OF.invoke(this.delegate));
        }
        return SoyExpression.forString(MethodRef.RUNTIME_COERCE_TO_STRING.invoke(this.delegate));
    }

    SoyExpression coerceToDouble() {
        if (!this.isBoxed()) {
            if (this.soyRuntimeType().isKnownFloat()) {
                return this;
            }
            if (this.soyRuntimeType().isKnownInt()) {
                return SoyExpression.forFloat(BytecodeUtils.numericConversion(this.delegate, Type.DOUBLE_TYPE));
            }
            throw new UnsupportedOperationException("Can't convert " + this.resultType() + " to a double");
        }
        if (this.soyRuntimeType().isKnownFloat()) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_NUMBER_VALUE, new Expression[0]));
    }

    SoyExpression unboxAs(Class<?> asType) {
        Preconditions.checkArgument((!SoyValue.class.isAssignableFrom(asType) ? 1 : 0) != 0, (String)"Cannot use unboxAs() to convert to a SoyValue: %s, use .box() instead", (Object[])new Object[]{asType});
        if (BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(asType), this.soyType.runtimeType())) {
            return this;
        }
        if (!this.isBoxed()) {
            throw new IllegalStateException("Trying to unbox an unboxed value (" + this.soyType + ") doesn't make sense, " + "should you be using a type coercion? e.g. .coerceToBoolean()");
        }
        if (asType.equals(Boolean.TYPE)) {
            return SoyExpression.forBool(this.delegate.invoke(MethodRef.SOY_VALUE_BOOLEAN_VALUE, new Expression[0]));
        }
        if (asType.equals(Long.TYPE)) {
            return SoyExpression.forInt(this.delegate.invoke(MethodRef.SOY_VALUE_LONG_VALUE, new Expression[0]));
        }
        if (asType.equals(Double.TYPE)) {
            return SoyExpression.forFloat(this.delegate.invoke(MethodRef.SOY_VALUE_FLOAT_VALUE, new Expression[0]));
        }
        if (this.delegate.isNonNullable()) {
            if (asType.equals(String.class)) {
                Expression unboxedString = this.delegate.invoke(MethodRef.SOY_VALUE_STRING_VALUE, new Expression[0]);
                return this.soyRuntimeType().isKnownSanitizedContent() ? SoyExpression.forSanitizedString(unboxedString, ((SanitizedType)this.soyType.soyType()).getContentKind()) : SoyExpression.forString(unboxedString);
            }
            if (asType.equals(List.class)) {
                return this.unboxAsList();
            }
        } else {
            final Label end = new Label();
            Expression nonNullDelegate = new Expression(this.resultType(), this.features()){

                @Override
                void doGen(CodeBuilder adapter) {
                    SoyExpression.this.delegate.gen(adapter);
                    BytecodeUtils.nullCoalesce(adapter, end);
                }
            };
            return this.withSource(nonNullDelegate).asNonNullable().unboxAs(asType).asNullable().labelEnd(end);
        }
        throw new UnsupportedOperationException("Can't unbox " + this.soyType + " as " + asType);
    }

    private SoyExpression unboxAsList() {
        ListType asListType;
        if (this.isKnownList()) {
            asListType = (ListType)this.soyType.soyType();
        } else {
            SoyType.Kind kind = this.soyType.soyType().getKind();
            if (kind == SoyType.Kind.UNKNOWN) {
                asListType = ListType.of(UnknownType.getInstance());
            } else {
                throw new UnsupportedOperationException("Cannot convert " + this.soyType + " to List");
            }
        }
        return SoyExpression.forList(asListType, this.delegate.cast(BytecodeUtils.SOY_LIST_TYPE).invoke(MethodRef.SOY_LIST_AS_JAVA_LIST, new Expression[0]));
    }

    SoyExpression withSource(Expression expr) {
        return new SoyExpression(this.soyType, expr, this.renderContext);
    }

    SoyExpression withRenderContext(Expression renderContext) {
        if (this.renderContext.isPresent() && ((Expression)this.renderContext.get()).equals(renderContext)) {
            return this;
        }
        return new SoyExpression(this.soyType, this.delegate, (Optional<Expression>)Optional.of((Object)renderContext));
    }

    SoyExpression applyPrintDirective(Expression renderContext, String directive) {
        return this.applyPrintDirective(renderContext, directive, MethodRef.IMMUTABLE_LIST_OF.invoke(new Expression[0]));
    }

    SoyExpression applyPrintDirective(Expression renderContext, String directive, Expression argsList) {
        return SoyExpression.forSoyValue(UnknownType.getInstance(), MethodRef.RUNTIME_APPLY_PRINT_DIRECTIVE.invoke(renderContext.invoke(MethodRef.RENDER_CONTEXT_GET_PRINT_DIRECTIVE, BytecodeUtils.constant(directive)), this.box(), argsList));
    }

    @Override
    SoyExpression asCheap() {
        return this.withSource(this.delegate.asCheap());
    }

    @Override
    SoyExpression asNonNullable() {
        return new SoyExpression(this.soyType.asNonNullable(), this.delegate.asNonNullable(), this.renderContext);
    }

    @Override
    public SoyExpression asNullable() {
        return new SoyExpression(this.soyType.asNullable(), this.delegate.asNullable(), this.renderContext);
    }

    @Override
    SoyExpression labelStart(Label label) {
        return this.withSource(this.delegate.labelStart(label));
    }

    @Override
    SoyExpression labelEnd(Label label) {
        return this.withSource(this.delegate.labelEnd(label));
    }

    private static final class DefaultBoxed
    extends SoyExpression {
        private final SoyExpression unboxed;

        DefaultBoxed(SoyRuntimeType soyType, SoyExpression unboxed, Expression delegate, Optional<Expression> expr) {
            super(soyType, delegate, expr);
            this.unboxed = unboxed;
        }

        @Override
        final SoyExpression unboxAs(Class<?> asType) {
            return this.unboxed.unboxAs(asType);
        }

        @Override
        SoyExpression coerceToBoolean() {
            return this.unboxed.coerceToBoolean();
        }

        @Override
        SoyExpression coerceToString() {
            return this.unboxed.coerceToString();
        }

        @Override
        SoyExpression coerceToDouble() {
            return this.unboxed.coerceToDouble();
        }

        @Override
        final SoyExpression box() {
            return this;
        }
    }
}

