/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.template.soy.html.HtmlAttributeNode;
import com.google.template.soy.html.HtmlCloseTagNode;
import com.google.template.soy.html.HtmlOpenTagEndNode;
import com.google.template.soy.html.HtmlOpenTagNode;
import com.google.template.soy.html.HtmlOpenTagStartNode;
import com.google.template.soy.html.HtmlVoidTagNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import java.util.List;

final class IncrementalDomOutputOptimizers {
    private IncrementalDomOutputOptimizers() {
    }

    static void collapseElements(SoyNode node) {
        List<HtmlOpenTagNode> openTagNodes = SoytreeUtils.getAllNodesOfType(node, HtmlOpenTagNode.class);
        for (HtmlOpenTagNode openTagNode : openTagNodes) {
            HtmlCloseTagNode closeTagNode;
            SoyNode.StandaloneNode nextNode;
            SoyNode.BlockNode parent = openTagNode.getParent();
            int nextIndex = parent.getChildIndex(openTagNode) + 1;
            if (nextIndex >= parent.getChildren().size() || !((nextNode = (SoyNode.StandaloneNode)parent.getChild(nextIndex)) instanceof HtmlCloseTagNode) || !(closeTagNode = (HtmlCloseTagNode)nextNode).getTagName().equals(openTagNode.getTagName())) continue;
            HtmlVoidTagNode htmlVoidTagNode = new HtmlVoidTagNode(openTagNode.getId(), openTagNode.getTagName(), openTagNode.getSourceLocation());
            htmlVoidTagNode.addChildren(openTagNode.getChildren());
            parent.replaceChild(openTagNode, htmlVoidTagNode);
            parent.removeChild(closeTagNode);
        }
    }

    static void collapseOpenTags(SoyNode node) {
        List<HtmlOpenTagStartNode> openTagStartNodes = SoytreeUtils.getAllNodesOfType(node, HtmlOpenTagStartNode.class);
        for (HtmlOpenTagStartNode openTagStartNode : openTagStartNodes) {
            int currentIndex;
            SoyNode.BlockNode parent = openTagStartNode.getParent();
            List children = parent.getChildren();
            int startIndex = children.indexOf(openTagStartNode);
            SoyNode.StandaloneNode currentNode = null;
            for (currentIndex = startIndex + 1; currentIndex < children.size() && (currentNode = (SoyNode.StandaloneNode)children.get(currentIndex)) instanceof HtmlAttributeNode; ++currentIndex) {
            }
            if (!(currentNode instanceof HtmlOpenTagEndNode)) continue;
            List tagNodesRange = children.subList(startIndex, currentIndex + 1);
            HtmlOpenTagNode openTagNode = new HtmlOpenTagNode(openTagStartNode.getId(), openTagStartNode.getTagName(), openTagStartNode.getSourceLocation().extend(currentNode.getSourceLocation()));
            for (SoyNode.StandaloneNode standaloneNode : tagNodesRange.subList(1, tagNodesRange.size() - 1)) {
                openTagNode.addChild((HtmlAttributeNode)standaloneNode);
            }
            tagNodesRange.clear();
            parent.addChild(startIndex, openTagNode);
        }
    }
}

