/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.data.SoyAbstractCachingRecord;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.types.proto.SoyProtoTypeImpl;
import java.io.IOException;
import java.util.Collection;

public final class SoyProtoValue
extends SoyAbstractCachingRecord
implements SoyProtoTypeImpl.Value,
SoyMap {
    private final SoyValueConverter valueConverter;
    private final Message proto;
    private final SoyProtoTypeImpl type;

    SoyProtoValue(SoyValueConverter valueConverter, SoyProtoTypeImpl type, Message proto) {
        this.valueConverter = (SoyValueConverter)Preconditions.checkNotNull((Object)valueConverter);
        this.proto = (Message)Preconditions.checkNotNull((Object)proto);
        this.type = (SoyProtoTypeImpl)Preconditions.checkNotNull((Object)type);
    }

    @Override
    public boolean hasField(String name) {
        SoyProtoTypeImpl.Field fieldDesc = this.type.getField(name);
        if (fieldDesc == null) {
            return false;
        }
        return fieldDesc.hasField(this.proto);
    }

    @Override
    public SoyValueProvider getFieldProviderInternal(final String name) {
        if (!this.hasField(name)) {
            return null;
        }
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return SoyProtoValue.this.type.getField(name).intepretField(SoyProtoValue.this.valueConverter, SoyProtoValue.this.proto).resolve();
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    @Override
    public boolean hasItem(SoyValue key) {
        return this.hasField(key.stringValue());
    }

    @Override
    public SoyValueProvider getItemProvider(SoyValue key) {
        return this.getFieldProvider(key.stringValue());
    }

    @Override
    public SoyValue getItem(SoyValue key) {
        return this.getField(key.stringValue());
    }

    public Collection<SoyValue> getItemKeys() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : this.type.getFieldNames()) {
            if (!this.hasField(key)) continue;
            builder.add((Object)StringData.forValue(key));
        }
        return builder.build();
    }

    @Override
    public int getItemCnt() {
        return this.getItemKeys().size();
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.proto == ((SoyProtoValue)other).proto;
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public void render(Appendable appendable) throws IOException {
        TextFormat.print((MessageOrBuilder)this.proto, (Appendable)appendable);
    }

    @Override
    public String coerceToString() {
        return this.proto.toString();
    }

    @Override
    public Message getProto() {
        return this.proto;
    }

    public String toString() {
        return String.format("SoyProtoValue<%s>", this.proto.getDescriptorForType().getFullName());
    }
}

