/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateDelegateNodeBuilder
extends TemplateNodeBuilder {
    private static final SoyErrorKind INVALID_DELTEMPLATE_COMMAND_TEXT = SoyErrorKind.of("Invalid deltemplate command text.");
    private static final SoyErrorKind INVALID_DELTEMPLATE_NAME = SoyErrorKind.of("Invalid name.  deltemplate names should be fully qualified.");
    private static final SoyErrorKind INVALID_VARIANT_EXPR = SoyErrorKind.of("Invalid variant expression (must be a string literal containing an identifier or global expression).");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("^\\s*([.\\w]+)(\\s.*|$)", 32);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("deltemplate", new CommandTextAttributesParser.Attribute("variant", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("autoescape", AutoescapeMode.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("kind", NodeContentKinds.getAttributeValues(), null), new CommandTextAttributesParser.Attribute("requirecss", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("cssbase", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("deprecatedV1", CommandTextAttributesParser.Attribute.BOOLEAN_VALUES, "false"));
    private String delTemplateName;
    private String delTemplateVariant = null;
    private ExprRootNode delTemplateVariantExpr = null;
    private TemplateDelegateNode.DelTemplateKey delTemplateKey;
    private TemplateNode.Priority delPriority;

    public TemplateDelegateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, SourceLocation sourceLocation, ErrorReporter errorReporter) {
        super(soyFileHeaderInfo, sourceLocation, errorReporter, null);
    }

    public TemplateDelegateNodeBuilder(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, SourceLocation sourceLocation, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry) {
        super(soyFileHeaderInfo, sourceLocation, errorReporter, typeRegistry);
    }

    @Override
    public TemplateDelegateNodeBuilder setId(int id) {
        return (TemplateDelegateNodeBuilder)super.setId(id);
    }

    @Override
    public TemplateDelegateNodeBuilder setCmdText(String cmdText) {
        Map<String, String> attributes;
        String variantExprText;
        Preconditions.checkState((this.cmdText == null ? 1 : 0) != 0);
        this.cmdText = cmdText;
        if (this.soyFileHeaderInfo.namespace == null) {
            throw LegacyInternalSyntaxException.createWithMetaInfo("Cannot declare deltemplates in files with no namespace declaration.", this.sourceLocation);
        }
        Matcher matcher = COMMAND_TEXT_PATTERN.matcher(cmdText);
        if (!matcher.matches()) {
            this.errorReporter.report(this.sourceLocation, INVALID_DELTEMPLATE_COMMAND_TEXT, new Object[0]);
            return this;
        }
        this.delTemplateName = matcher.group(1);
        if (!BaseUtils.isDottedIdentifier(this.delTemplateName)) {
            this.errorReporter.report(this.sourceLocation, INVALID_DELTEMPLATE_NAME, new Object[0]);
        }
        if ((variantExprText = (attributes = ATTRIBUTES_PARSER.parse(matcher.group(2).trim(), this.errorReporter, this.sourceLocation)).get("variant")) == null) {
            this.delTemplateVariant = "";
        } else {
            ExprNode variantExpr = new ExpressionParser(variantExprText, this.sourceLocation, SoyParsingContext.create(this.errorReporter, this.soyFileHeaderInfo.namespace, this.soyFileHeaderInfo.aliasToNamespaceMap)).parseExpression();
            if (variantExpr instanceof StringNode) {
                this.delTemplateVariant = ((StringNode)variantExpr).getValue();
                TemplateDelegateNode.verifyVariantName(this.delTemplateVariant, this.sourceLocation);
            } else if (variantExpr instanceof GlobalNode) {
                this.delTemplateVariantExpr = new ExprRootNode(variantExpr);
                this.templateNameForUserMsgs = this.delTemplateName + ":" + ((GlobalNode)variantExpr).getName();
            } else {
                this.errorReporter.report(this.sourceLocation, INVALID_VARIANT_EXPR, new Object[0]);
            }
        }
        if (this.delTemplateVariant != null) {
            this.delTemplateKey = TemplateDelegateNode.DelTemplateKey.create(this.delTemplateName, this.delTemplateVariant);
            this.templateNameForUserMsgs = this.delTemplateKey.toString();
        }
        this.delPriority = this.soyFileHeaderInfo.priority;
        this.setAutoescapeCmdText(attributes);
        this.setRequireCssCmdText(attributes);
        this.setCssBaseCmdText(attributes);
        this.setV1Marker(attributes);
        this.genInternalTemplateNameHelper();
        return this;
    }

    public TemplateDelegateNodeBuilder setCmdTextInfo(String delTemplateName, String delTemplateVariant, TemplateNode.Priority delPriority, AutoescapeMode autoescapeMode, SanitizedContent.ContentKind contentKind, ImmutableList<String> requiredCssNamespaces) {
        Preconditions.checkState((this.cmdText == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(delTemplateName));
        Preconditions.checkArgument((delTemplateVariant.length() == 0 || BaseUtils.isIdentifier(delTemplateVariant) ? 1 : 0) != 0);
        Preconditions.checkArgument((contentKind != null == (autoescapeMode == AutoescapeMode.STRICT) ? 1 : 0) != 0);
        this.delTemplateName = delTemplateName;
        this.delTemplateVariant = delTemplateVariant;
        this.delTemplateKey = TemplateDelegateNode.DelTemplateKey.create(delTemplateName, delTemplateVariant);
        this.templateNameForUserMsgs = this.delTemplateKey.toString();
        this.delPriority = delPriority;
        this.setAutoescapeInfo(autoescapeMode, contentKind);
        this.setRequiredCssNamespaces(requiredCssNamespaces);
        String cmdText = delTemplateName + (delTemplateVariant.length() == 0 ? "" : " variant=\"" + delTemplateVariant + "\"") + " autoescape=\"" + autoescapeMode.getAttributeValue() + "\"";
        if (contentKind != null) {
            cmdText = cmdText + " kind=\"" + NodeContentKinds.toAttributeValue(contentKind) + '\"';
        }
        if (!requiredCssNamespaces.isEmpty()) {
            cmdText = cmdText + " requirecss=\"" + Joiner.on((String)", ").join(requiredCssNamespaces) + "\"";
        }
        this.cmdText = cmdText;
        this.genInternalTemplateNameHelper();
        return this;
    }

    private void genInternalTemplateNameHelper() {
        Preconditions.checkState((this.id != null ? 1 : 0) != 0);
        String delPackageAndDelTemplateStr = (this.soyFileHeaderInfo.delPackageName == null ? "" : this.soyFileHeaderInfo.delPackageName) + "~" + this.delTemplateName + "~" + this.delTemplateVariant;
        String collisionPreventionStr = BaseUtils.computePartialSha1AsHexString(delPackageAndDelTemplateStr, 32);
        String generatedPartialTemplateName = ".__deltemplate_s" + this.id + "_" + collisionPreventionStr;
        String generatedTemplateName = this.soyFileHeaderInfo.namespace + generatedPartialTemplateName;
        this.setTemplateNames(generatedTemplateName, generatedPartialTemplateName);
    }

    @Override
    public TemplateDelegateNodeBuilder setSoyDoc(String soyDoc) {
        return (TemplateDelegateNodeBuilder)super.setSoyDoc(soyDoc);
    }

    @Override
    public TemplateDelegateNodeBuilder setHeaderDecls(TemplateNodeBuilder.DeclInfo ... declInfos) {
        return (TemplateDelegateNodeBuilder)super.setHeaderDecls(declInfos);
    }

    @Override
    public TemplateDelegateNodeBuilder addParams(Iterable<? extends TemplateParam> allParams) {
        return (TemplateDelegateNodeBuilder)super.addParams(allParams);
    }

    @Override
    public TemplateDelegateNode build() {
        Preconditions.checkState((this.id != null && this.cmdText != null ? 1 : 0) != 0);
        return new TemplateDelegateNode(this, this.soyFileHeaderInfo, this.delTemplateName, this.delTemplateVariant, this.delTemplateVariantExpr, this.delTemplateKey, this.delPriority, (ImmutableList<TemplateParam>)this.params);
    }
}

