/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class LetValueNode
extends LetNode
implements SoyNode.ExprHolderNode {
    public static final SoyErrorKind SELF_ENDING_WITHOUT_VALUE = SoyErrorKind.of("A ''let'' tag should be self-ending (with a trailing ''/'') if and only if it also contains a value (invalid tag is '{'let {0} /'}').");
    private static final SoyErrorKind KIND_ATTRIBUTE_NOT_ALLOWED_WITH_VALUE = SoyErrorKind.of("The ''kind'' attribute is not allowed on self-ending ''let'' tags that contain a value (invalid tag is '{'let {0} /'}').");
    private final ExprRootNode valueExpr;

    private LetValueNode(int id, SourceLocation sourceLocation, String localVarName, String commandText, ExprRootNode valueExpr) {
        super(id, sourceLocation, localVarName, commandText);
        this.valueExpr = valueExpr;
    }

    private LetValueNode(LetValueNode orig, CopyState copyState) {
        super(orig, copyState);
        this.valueExpr = orig.valueExpr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.LET_VALUE_NODE;
    }

    @Override
    public final String getVarName() {
        return this.var.name();
    }

    public ExprRootNode getValueExpr() {
        return this.valueExpr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.valueExpr));
    }

    @Override
    public LetValueNode copy(CopyState copyState) {
        return new LetValueNode(this, copyState);
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(true);
    }

    public static final class Builder {
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        private static LetValueNode error() {
            return new Builder(-1, "$error: 1", SourceLocation.UNKNOWN).build(SoyParsingContext.exploding());
        }

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public LetValueNode build(SoyParsingContext context) {
            ErrorReporter.Checkpoint checkpoint = context.errorReporter().checkpoint();
            LetNode.CommandTextParseResult parseResult = LetNode.parseCommandTextHelper(this.commandText, context, this.sourceLocation);
            if (parseResult.valueExpr == null) {
                context.report(this.sourceLocation, SELF_ENDING_WITHOUT_VALUE, this.commandText);
            }
            if (parseResult.contentKind != null) {
                context.report(this.sourceLocation, KIND_ATTRIBUTE_NOT_ALLOWED_WITH_VALUE, this.commandText);
            }
            if (context.errorReporter().errorsSince(checkpoint)) {
                return Builder.error();
            }
            return new LetValueNode(this.id, this.sourceLocation, parseResult.localVarName, this.commandText, parseResult.valueExpr);
        }
    }
}

