/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Set;

public enum AutoescapeMode {
    NONCONTEXTUAL("deprecated-noncontextual"),
    CONTEXTUAL("deprecated-contextual"),
    STRICT("strict");

    private static final SoyErrorKind INVALID_AUTOESCAPE_ERROR;
    private static final ImmutableMap<String, AutoescapeMode> valueToModeMap;
    private final String attributeValue;

    private AutoescapeMode(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static Set<String> getAttributeValues() {
        return valueToModeMap.keySet();
    }

    static AutoescapeMode parseAutoEscapeMode(String autoescapeModeStr) {
        AutoescapeMode parsed = (AutoescapeMode)((Object)valueToModeMap.get((Object)autoescapeModeStr));
        if (parsed == null) {
            return STRICT;
        }
        return parsed;
    }

    static AutoescapeMode parseAutoEscapeMode(String autoescapeModeStr, SourceLocation loc, ErrorReporter reporter) {
        AutoescapeMode parsed = (AutoescapeMode)((Object)valueToModeMap.get((Object)autoescapeModeStr));
        if (parsed == null) {
            reporter.report(loc, INVALID_AUTOESCAPE_ERROR, autoescapeModeStr, valueToModeMap.keySet());
            return STRICT;
        }
        return parsed;
    }

    static {
        INVALID_AUTOESCAPE_ERROR = SoyErrorKind.of("invalid ''autoescape'' value ''{0}'', expected one of {1}");
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (AutoescapeMode value : AutoescapeMode.values()) {
            map.put((Object)value.attributeValue, (Object)value);
        }
        valueToModeMap = map.build();
    }
}

