/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;

public final class VerifyPhnameAttrOnlyOnPlaceholdersVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind INVALID_PLACEHOLDER = SoyErrorKind.of("''phname'' attributes are only valid inside '''{'msg...'' tags");
    private final ErrorReporter errorReporter;

    public VerifyPhnameAttrOnlyOnPlaceholdersVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.visitMsgPlaceholderInitialContentNodeHelper(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        this.visitMsgPlaceholderInitialContentNodeHelper(node);
        this.visitChildren(node);
    }

    private void visitMsgPlaceholderInitialContentNodeHelper(SoyNode.MsgPlaceholderInitialNode node) {
        if (node.getUserSuppliedPhName() != null && !(node.getParent() instanceof MsgPlaceholderNode)) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_PLACEHOLDER, new Object[0]);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

