/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.InjectedParam;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.UndeclaredVar;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class ResolveNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind GLOBAL_MATCHES_VARIABLE = SoyErrorKind.of("Found global reference aliasing a local variable ''{0}'', did you mean ''${0}''?");
    private static final SoyErrorKind VARIABLE_ALREADY_DEFINED = SoyErrorKind.of("variable ''${0}'' already defined{1}");
    private LocalVariables localVariables;
    private Map<String, InjectedParam> ijParams;
    private final ErrorReporter errorReporter;

    ResolveNamesVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.localVariables = new LocalVariables();
        this.localVariables.enterScope();
        this.ijParams = new HashMap<String, InjectedParam>();
        for (TemplateParam param : node.getAllParams()) {
            this.localVariables.define(param, (SoyNode)node);
        }
        this.visitSoyNode(node);
        this.localVariables.exitScope();
        this.localVariables.verify();
        node.setMaxLocalVariableTableSize(this.localVariables.nextSlotToClaim);
        this.localVariables = null;
        this.ijParams = null;
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.visitSoyNode(node);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.visitExpressions(node);
        this.localVariables.define(node.getVar(), (SoyNode)node);
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.localVariables.enterLazyScope();
        this.visitChildren(node);
        this.localVariables.exitLazyScope();
        this.localVariables.define(node.getVar(), (SoyNode)node);
    }

    @Override
    protected void visitForNode(ForNode node) {
        this.visitExpressions(node);
        this.localVariables.enterScope();
        this.localVariables.define(node.getVar(), (SoyNode)node);
        this.visitChildren(node);
        this.localVariables.exitScope();
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        this.visitExpressions(node.getParent());
        this.localVariables.enterScope();
        this.localVariables.define(node.getVar(), (SoyNode)node);
        this.visitChildren(node);
        this.localVariables.exitScope();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ExprHolderNode) {
            this.visitExpressions((SoyNode.ExprHolderNode)node);
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.localVariables.enterScope();
                this.visitChildren((SoyNode.BlockNode)node);
                this.localVariables.exitScope();
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        ResolveNamesExprVisitor exprVisitor = new ResolveNamesExprVisitor();
        for (ExprUnion exprUnion : node.getAllExprUnions()) {
            if (exprUnion.getExpr() == null) continue;
            exprVisitor.exec(exprUnion.getExpr());
        }
    }

    private static Optional<SourceLocation> forVarDefn(VarDefn varDefn) {
        if (varDefn instanceof LocalVar) {
            return Optional.of((Object)((LocalVar)varDefn).declaringNode().getSourceLocation());
        }
        return Optional.absent();
    }

    private final class ResolveNamesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private ResolveNamesExprVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
            String globalName = node.getName();
            VarDefn varDefn = ResolveNamesVisitor.this.localVariables.lookup(globalName);
            if (varDefn != null) {
                node.suppressUnknownGlobalErrors();
                ResolveNamesVisitor.this.errorReporter.report(node.getSourceLocation(), GLOBAL_MATCHES_VARIABLE, globalName);
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            if (varRef.isDollarSignIjParameter()) {
                InjectedParam ijParam = (InjectedParam)ResolveNamesVisitor.this.ijParams.get(varRef.getName());
                if (ijParam == null) {
                    ijParam = new InjectedParam(varRef.getName());
                    ResolveNamesVisitor.this.ijParams.put(varRef.getName(), ijParam);
                }
                varRef.setDefn(ijParam);
                return;
            }
            VarDefn varDefn = ResolveNamesVisitor.this.localVariables.lookup(varRef.getName());
            if (varDefn == null) {
                varDefn = new UndeclaredVar(varRef.getName());
            }
            varRef.setDefn(varDefn);
        }
    }

    private final class LocalVariables {
        private final BitSet availableSlots = new BitSet();
        private final Deque<Map<String, VarDefn>> currentScope = new ArrayDeque<Map<String, VarDefn>>();
        private final BitSet slotsToRelease = new BitSet();
        private int nextSlotToClaim = 0;
        private int delayReleaseClaims = 0;

        private LocalVariables() {
        }

        void enterScope() {
            this.currentScope.push(new LinkedHashMap());
        }

        void enterLazyScope() {
            ++this.delayReleaseClaims;
            this.enterScope();
        }

        void exitLazyScope() {
            Preconditions.checkState((this.delayReleaseClaims > 0 ? 1 : 0) != 0, (Object)"Exiting a lazy scope when we aren't in one");
            this.exitScope();
            --this.delayReleaseClaims;
        }

        void exitScope() {
            Map<String, VarDefn> variablesGoingOutOfScope = this.currentScope.pop();
            for (VarDefn var : variablesGoingOutOfScope.values()) {
                if (var instanceof LoopVar) {
                    LoopVar loopVar = (LoopVar)var;
                    this.slotsToRelease.set(loopVar.currentLoopIndexIndex());
                    this.slotsToRelease.set(loopVar.isLastIteratorIndex());
                }
                this.slotsToRelease.set(var.localVariableIndex());
            }
            if (this.delayReleaseClaims == 0) {
                this.availableSlots.or(this.slotsToRelease);
                this.slotsToRelease.clear();
            }
        }

        VarDefn lookup(String name) {
            for (Map<String, VarDefn> scope : this.currentScope) {
                VarDefn defn = scope.get(name);
                if (defn == null) continue;
                return defn;
            }
            return null;
        }

        boolean define(LoopVar defn, SoyNode definingNode) {
            if (!this.define((VarDefn)defn, definingNode)) {
                return false;
            }
            defn.setExtraLoopIndices(this.claimSlot(), this.claimSlot());
            return true;
        }

        boolean define(VarDefn defn, SoyNode definingNode) {
            VarDefn preexisting = this.lookup(defn.name());
            if (preexisting != null) {
                Optional sourceLocation = ResolveNamesVisitor.forVarDefn(preexisting);
                String location = sourceLocation.isPresent() ? " at line " + ((SourceLocation)sourceLocation.get()).getLineNumber() : "";
                ResolveNamesVisitor.this.errorReporter.report(definingNode.getSourceLocation(), VARIABLE_ALREADY_DEFINED, defn.name(), location);
                return false;
            }
            this.currentScope.peek().put(defn.name(), defn);
            defn.setLocalVariableIndex(this.claimSlot());
            return true;
        }

        private int claimSlot() {
            int slotToUse;
            int nextSetBit = this.availableSlots.nextSetBit(0);
            if (nextSetBit != -1) {
                slotToUse = nextSetBit;
                this.availableSlots.clear(nextSetBit);
            } else {
                slotToUse = this.nextSlotToClaim++;
            }
            return slotToUse;
        }

        void verify() {
            Preconditions.checkState((this.delayReleaseClaims == 0 ? 1 : 0) != 0, (String)"%s lazy scope(s) are still active", (Object[])new Object[]{this.delayReleaseClaims});
            Preconditions.checkState((boolean)this.slotsToRelease.isEmpty(), (String)"%s slots are waiting to be released", (Object[])new Object[]{this.slotsToRelease});
            BitSet unavailableSlots = new BitSet(this.nextSlotToClaim);
            unavailableSlots.set(0, this.nextSlotToClaim);
            unavailableSlots.xor(this.availableSlots);
            Preconditions.checkState((boolean)unavailableSlots.isEmpty(), (String)"Expected all slots to be available: %s", (Object[])new Object[]{unavailableSlots});
        }
    }
}

