/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;

final class CheckTemplateVisibility
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind CALLEE_NOT_VISIBLE = SoyErrorKind.of("Template {0} has {1} visibility, not visible from here.");
    private final ErrorReporter errorReporter;
    private final TemplateRegistry templateRegistry;
    private String currentFileName;

    CheckTemplateVisibility(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.currentFileName = node.getSourceLocation().getFileName();
        this.visitChildren(node);
        this.currentFileName = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        if (node instanceof CallBasicNode) {
            this.handleBasicNode((CallBasicNode)node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void handleBasicNode(CallBasicNode node) {
        String calleeName = node.getCalleeName();
        TemplateBasicNode definition = this.templateRegistry.getBasicTemplate(calleeName);
        if (definition != null && !this.isVisible(definition)) {
            this.errorReporter.report(node.getSourceLocation(), CALLEE_NOT_VISIBLE, calleeName, definition.getVisibility().getAttributeValue());
        }
    }

    private boolean isVisible(TemplateNode definition) {
        if (definition.getVisibility() != Visibility.PRIVATE) {
            return true;
        }
        return this.currentFileName.equals(definition.getSourceLocation().getFileName());
    }
}

