/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Rewriter {
    private final Inferences inferences;
    private final Set<String> visitedTemplateNames = Sets.newHashSet();
    private final Map<String, SanitizedContent.ContentKind> sanitizedContentOperators;
    private final ErrorReporter errorReporter;

    Rewriter(Inferences inferences, Map<String, SanitizedContent.ContentKind> sanitizedContentOperators, ErrorReporter errorReporter) {
        this.inferences = inferences;
        this.sanitizedContentOperators = sanitizedContentOperators;
        this.errorReporter = errorReporter;
    }

    public List<TemplateNode> rewrite(SoyFileSetNode files) {
        RewriterVisitor mutator = new RewriterVisitor();
        for (SoyFileNode file : files.getChildren()) {
            mutator.exec(file);
        }
        ImmutableList.Builder extraTemplates = ImmutableList.builder();
        for (TemplateNode template : this.inferences.getAllTemplates()) {
            String name = template.getTemplateName();
            if (this.visitedTemplateNames.contains(name)) continue;
            extraTemplates.add((Object)template);
            mutator.exec(template);
        }
        return extraTemplates.build();
    }

    private static void replaceChild(SoyNode.StandaloneNode oldChild, SoyNode.StandaloneNode newChild) {
        oldChild.getParent().replaceChild(oldChild, newChild);
    }

    private static <T extends SoyNode> void moveChildrenTo(SoyNode.ParentSoyNode<T> oldParent, SoyNode.ParentSoyNode<T> newParent) {
        ImmutableList children = ImmutableList.copyOf(oldParent.getChildren());
        oldParent.clearChildren();
        newParent.addChildren((List<T>)children);
    }

    private final class RewriterVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private RewriterVisitor() {
        }

        @Override
        protected void visitTemplateNode(TemplateNode templateNode) {
            Preconditions.checkState((!Rewriter.this.visitedTemplateNames.contains(templateNode.getTemplateName()) ? 1 : 0) != 0);
            Rewriter.this.visitedTemplateNames.add(templateNode.getTemplateName());
            this.visitChildrenAllowingConcurrentModification(templateNode);
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            int id = printNode.getId();
            ImmutableList<EscapingMode> escapingModes = Rewriter.this.inferences.getEscapingModesForId(id);
            for (EscapingMode escapingMode : escapingModes) {
                int newPrintDirectiveIndex;
                PrintDirectiveNode newPrintDirective = new PrintDirectiveNode.Builder(Rewriter.this.inferences.getIdGenerator().genId(), escapingMode.directiveName, "", printNode.getSourceLocation()).build(SoyParsingContext.exploding());
                for (newPrintDirectiveIndex = printNode.numChildren(); newPrintDirectiveIndex > 0; --newPrintDirectiveIndex) {
                    String printDirectiveName = ((PrintDirectiveNode)printNode.getChild(newPrintDirectiveIndex - 1)).getName();
                    SanitizedContent.ContentKind contentKind = (SanitizedContent.ContentKind)((Object)Rewriter.this.sanitizedContentOperators.get(printDirectiveName));
                    if (contentKind == null || contentKind != escapingMode.contentKind) break;
                }
                printNode.addChild(newPrintDirectiveIndex, newPrintDirective);
            }
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
        }

        private ImmutableList<String> getDirectiveNamesForNode(SoyNode node) {
            ImmutableList.Builder escapingDirectiveNames = new ImmutableList.Builder();
            for (EscapingMode escapingMode : Rewriter.this.inferences.getEscapingModesForId(node.getId())) {
                escapingDirectiveNames.add((Object)escapingMode.directiveName);
            }
            return escapingDirectiveNames.build();
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            node.setEscapingDirectiveNames(this.getDirectiveNamesForNode(node));
            this.visitChildren(node);
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            SoyParsingContext context = SoyParsingContext.empty(Rewriter.this.errorReporter, "fake.namespace");
            String derivedCalleeName = Rewriter.this.inferences.getDerivedCalleeNameForCallId(callNode.getId());
            if (derivedCalleeName != null) {
                CallNode newCallNode;
                if (callNode instanceof CallBasicNode) {
                    newCallNode = new CallBasicNode.Builder(callNode.getId(), callNode.getSourceLocation()).calleeName(derivedCalleeName).sourceCalleeName(derivedCalleeName).dataAttribute(callNode.dataAttribute()).userSuppliedPlaceholderName(callNode.getUserSuppliedPhName()).syntaxVersionBound(callNode.getSyntaxVersionUpperBound()).escapingDirectiveNames(callNode.getEscapingDirectiveNames()).build(context);
                } else {
                    CallDelegateNode callNodeCast = (CallDelegateNode)callNode;
                    newCallNode = new CallDelegateNode.Builder(callNode.getId(), callNode.getSourceLocation()).delCalleeName(derivedCalleeName).delCalleeVariantExpr(callNodeCast.getDelCalleeVariantExpr()).allowEmptyDefault(callNodeCast.allowsEmptyDefault()).dataAttribute(callNode.dataAttribute()).userSuppliedPlaceholderName(callNode.getUserSuppliedPhName()).escapingDirectiveNames(callNode.getEscapingDirectiveNames()).build(context);
                }
                if (!callNode.getCommandText().equals(newCallNode.getCommandText())) {
                    Rewriter.moveChildrenTo(callNode, newCallNode);
                    Rewriter.replaceChild(callNode, newCallNode);
                }
                callNode = newCallNode;
            }
            callNode.setEscapingDirectiveNames(this.getDirectiveNamesForNode(callNode));
            this.visitChildrenAllowingConcurrentModification(callNode);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

