/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

final class CheckEscapingSanityVisitor
extends AbstractSoyNodeVisitor<Void> {
    private AutoescapeMode autoescapeMode;
    private final TemplateRegistry templateRegistry;
    private final ErrorReporter errorReporter;

    public CheckEscapingSanityVisitor(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.autoescapeMode = node.getAutoescapeMode();
        this.visitChildren(node);
    }

    @Override
    protected void visitPrintDirectiveNode(PrintDirectiveNode node) {
        EscapingMode escapingMode = EscapingMode.fromDirective(node.getName());
        if (escapingMode != null && escapingMode.isInternalOnly) {
            throw SoyAutoescapeException.createWithNode("Print directive " + node.getName() + " is only for internal use by the Soy compiler.", node);
        }
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitRenderUnitNode(node, "let", "{let $x: $y /}");
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee;
        if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && (callee = this.templateRegistry.getBasicTemplate(node.getCalleeName())) != null && callee.getContentKind() == SanitizedContent.ContentKind.TEXT) {
            throw SoyAutoescapeException.createWithNode("Calls to strict templates with 'kind=\"text\"' attribute is not permitted in non-contextually autoescaped templates: " + node.toSourceString(), node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        TemplateNode callee;
        ImmutableList divisions;
        if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && !(divisions = this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)node.getDelCalleeName())).isEmpty() && (callee = (TemplateNode)divisions.get(0)).getContentKind() == SanitizedContent.ContentKind.TEXT) {
            throw SoyAutoescapeException.createWithNode("Calls to strict templates with 'kind=\"text\"' attribute is not permitted in non-contextually autoescaped templates: " + node.toSourceString(), node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        this.visitRenderUnitNode(node, "param", "{param x: $y /}");
    }

    private void visitRenderUnitNode(SoyNode.RenderUnitNode node, String nodeName, String selfClosingExample) {
        AutoescapeMode oldMode = this.autoescapeMode;
        if (node.getContentKind() != null) {
            this.autoescapeMode = AutoescapeMode.STRICT;
        } else if (this.autoescapeMode == AutoescapeMode.STRICT) {
            throw SoyAutoescapeException.createWithNode("In strict templates, {" + nodeName + "}...{/" + nodeName + "} blocks require an " + "explicit kind=\"<type>\". This restriction will be lifted soon once a reasonable " + "default is chosen. (Note that " + selfClosingExample + " is NOT subject to this " + "restriction). Cause: " + node.getTagString(), node);
        }
        this.visitChildren(node);
        this.autoescapeMode = oldMode;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

