/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SoyFileSupplier;
import java.io.BufferedReader;
import java.io.IOException;

public final class SnippetFormatter {
    private final ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers;

    public SnippetFormatter(ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers) {
        this.filePathsToSuppliers = (ImmutableMap)Preconditions.checkNotNull(filePathsToSuppliers);
    }

    public Optional<String> getSnippet(SourceLocation sourceLocation) throws IOException {
        String result;
        SoyFileSupplier supplier = (SoyFileSupplier)this.filePathsToSuppliers.get((Object)sourceLocation.getFilePath());
        if (supplier == null) {
            return Optional.absent();
        }
        try (BufferedReader reader = new BufferedReader(supplier.open());){
            for (int linenum = 1; linenum < sourceLocation.getLineNumber(); ++linenum) {
                reader.readLine();
            }
            result = reader.readLine();
        }
        return Optional.of((Object)result);
    }
}

