/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.template.soy.base.internal.AbstractSoyFileSupplier;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public final class VolatileSoyFileSupplier
extends AbstractSoyFileSupplier {
    private final File file;

    public VolatileSoyFileSupplier(File file, SoyFileKind soyFileKind) {
        super(soyFileKind, file.getPath());
        this.file = file;
    }

    @Override
    public boolean hasChangedSince(SoyFileSupplier.Version version) {
        if (!(version instanceof VolatileFileVersion)) {
            return true;
        }
        return this.file.lastModified() != ((VolatileFileVersion)version).lastModified;
    }

    @Override
    public Reader open() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
    }

    @Override
    public SoyFileSupplier.Version getVersion() {
        return new VolatileFileVersion(this.file.lastModified());
    }

    private static final class VolatileFileVersion
    implements SoyFileSupplier.Version {
        final long lastModified;

        VolatileFileVersion(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof VolatileFileVersion && this.lastModified == ((VolatileFileVersion)other).lastModified;
        }

        public int hashCode() {
            return (int)this.lastModified;
        }

        public String toString() {
            return String.valueOf(this.lastModified);
        }
    }
}

