/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.internal.BaseUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.kohsuke.args4j.Option;

public final class SoyParseInfoGenerator
extends AbstractSoyCompiler {
    @Option(name="--allowExternalCalls", usage="Whether to allow external calls. New projects should set this to false, and existing projects should remove existing external calls and then set this to false. It will save you a lot of headaches. Currently defaults to true for backward compatibility.")
    private boolean allowExternalCalls = true;
    @Option(name="--outputDirectory", required=true, usage="[Required] The path to the output directory. If files with the same names already exist at this location, they will be overwritten.")
    private String outputDirectory = "";
    @Option(name="--javaPackage", required=true, usage="[Required] The Java package name to use for the generated classes.")
    private String javaPackage = "";
    @Option(name="--javaClassNameSource", required=true, usage="[Required] The source for the generated class names. Valid values are \"filename\", \"namespace\", and \"generic\". Option \"filename\" turns a Soy file name AaaBbb.soy or aaa_bbb.soy into AaaBbbSoyInfo. Option \"namespace\" turns a namespace aaa.bbb.cccDdd into CccDddSoyInfo (note it only uses the last part of the namespace). Option \"generic\" generates class names such as File1SoyInfo, File2SoyInfo.")
    private String javaClassNameSource = "";

    public static void main(String[] args) throws IOException {
        new SoyParseInfoGenerator().runMain(args);
    }

    @Override
    void validateFlags() {
        if (this.outputDirectory.length() == 0) {
            this.exitWithError("Must provide output directory.");
        }
        if (this.javaPackage.length() == 0) {
            this.exitWithError("Must provide Java package.");
        }
        if (this.javaClassNameSource.length() == 0) {
            this.exitWithError("Must provide Java class name source.");
        }
    }

    @Override
    void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        sfsBuilder.setAllowExternalCalls(this.allowExternalCalls);
        SoyFileSet sfs = sfsBuilder.build();
        ImmutableMap<String, String> parseInfo = sfs.generateParseInfo(this.javaPackage, this.javaClassNameSource);
        for (Map.Entry entry : parseInfo.entrySet()) {
            File outputFile = new File(this.outputDirectory, (String)entry.getKey());
            BaseUtils.ensureDirsExistInPath(outputFile.getPath());
            Files.write((CharSequence)((CharSequence)entry.getValue()), (File)outputFile, (Charset)StandardCharsets.UTF_8);
        }
    }
}

