/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyModule;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.SoyCompilationException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

final class MainClassUtils {
    private MainClassUtils() {
    }

    static CmdLineParser parseFlags(Object objWithFlags, String[] args, String usagePrefix) {
        CmdLineParser.registerHandler(Module.class, ModuleOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser cmdLineParser = new CmdLineParser(objWithFlags);
        cmdLineParser.setUsageWidth(100);
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            MainClassUtils.exitWithError(cle.getMessage(), cmdLineParser, usagePrefix);
        }
        return cmdLineParser;
    }

    static void run(Main method) {
        int status = MainClassUtils.runInternal(method);
        System.exit(status);
    }

    @VisibleForTesting
    static int runInternal(Main method) {
        try {
            method.main();
            return 0;
        }
        catch (SoyCompilationException compilationException) {
            System.err.println(compilationException.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("INTERNAL SOY ERROR.\nPlease open an issue at https://github.com/google/closure-templates/issues with this stack trace and repro steps");
            e.printStackTrace(System.err);
            return 1;
        }
    }

    static RuntimeException exitWithError(String errorMsg, CmdLineParser cmdLineParser, String usagePrefix) {
        System.err.println("\nError: " + errorMsg + "\n\n");
        System.err.println(usagePrefix);
        cmdLineParser.printUsage((OutputStream)System.err);
        System.exit(1);
        throw new AssertionError();
    }

    static Injector createInjector(String msgPluginModuleName, String pluginModuleNames) {
        Preconditions.checkArgument((!msgPluginModuleName.isEmpty() ? 1 : 0) != 0);
        return MainClassUtils.doCreateInjector(msgPluginModuleName, pluginModuleNames);
    }

    static Injector createInjectorForPlugins(String pluginModuleNames) {
        return MainClassUtils.doCreateInjector("", pluginModuleNames);
    }

    static Injector createInjectorForMsgPlugin(String msgPluginModuleName) {
        return MainClassUtils.doCreateInjector(msgPluginModuleName, "");
    }

    static Injector createInjector(List<Module> modules) {
        modules = new ArrayList<Module>(modules);
        modules.add((Module)new SoyModule());
        return Guice.createInjector(modules);
    }

    private static Injector doCreateInjector(String msgPluginModuleName, String pluginModuleNames) {
        ArrayList<SoyModule> guiceModules = new ArrayList<SoyModule>();
        guiceModules.add(new SoyModule());
        if (!msgPluginModuleName.isEmpty()) {
            guiceModules.add((SoyModule)MainClassUtils.instantiatePluginModule(msgPluginModuleName));
        }
        for (String pluginModuleName : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)pluginModuleNames)) {
            guiceModules.add((SoyModule)MainClassUtils.instantiatePluginModule(pluginModuleName));
        }
        return Guice.createInjector(guiceModules);
    }

    private static Module instantiatePluginModule(String moduleName) {
        try {
            return (Module)Class.forName(moduleName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot instantiate plugin module \"" + moduleName + "\".", e);
        }
    }

    static void addSoyFilesToBuilder(SoyFileSet.Builder sfsBuilder, String inputPrefix, Collection<String> srcs, Collection<String> args, Collection<String> deps, Collection<String> indirectDeps, Function<String, Void> exitWithErrorFn) {
        if (srcs.isEmpty() && args.isEmpty()) {
            exitWithErrorFn.apply((Object)"Must provide list of source Soy files (--srcs).");
        }
        if (!srcs.isEmpty() && !args.isEmpty()) {
            exitWithErrorFn.apply((Object)"Found source Soy files from --srcs and from args (please use --srcs only).");
        }
        ImmutableSet srcsSet = ImmutableSet.builder().addAll(srcs).addAll(args).build();
        Sets.SetView depsSet = Sets.difference((Set)ImmutableSet.copyOf(deps), (Set)srcsSet);
        Sets.SetView indirectDepsSet = Sets.difference((Set)ImmutableSet.copyOf(indirectDeps), (Set)Sets.union((Set)srcsSet, (Set)depsSet));
        for (String src : srcsSet) {
            sfsBuilder.addWithKind(new File(inputPrefix + src), SoyFileKind.SRC);
        }
        for (String dep : depsSet) {
            sfsBuilder.addWithKind(new File(inputPrefix + dep), SoyFileKind.DEP);
        }
        for (String dep : indirectDepsSet) {
            sfsBuilder.addWithKind(new File(inputPrefix + dep), SoyFileKind.INDIRECT_DEP);
        }
    }

    public static final class ModuleOptionHandler
    extends OptionHandler<Module> {
        public ModuleOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Module> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (parameter.isEmpty()) {
                this.setter.addValue(null);
            } else {
                this.setter.addValue((Object)MainClassUtils.instantiatePluginModule(parameter));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "com.foo.bar.BazModule";
        }
    }

    public static final class FileListOptionHandler
    extends ListOptionHandler<File> {
        public FileListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super File> setter) {
            super(parser, option, setter);
        }

        @Override
        File parseItem(String item) {
            return new File(item);
        }
    }

    public static final class ModuleListOptionHandler
    extends ListOptionHandler<Module> {
        public ModuleListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Module> setter) {
            super(parser, option, setter);
        }

        @Override
        Module parseItem(String item) {
            return MainClassUtils.instantiatePluginModule(item);
        }
    }

    public static final class StringListOptionHandler
    extends ListOptionHandler<String> {
        public StringListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
            super(parser, option, setter);
        }

        @Override
        String parseItem(String item) {
            return item;
        }
    }

    static abstract class ListOptionHandler<T>
    extends OptionHandler<T> {
        ListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
            super(parser, option, setter);
        }

        abstract T parseItem(String var1);

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (!parameter.isEmpty()) {
                for (String item : parameter.split(",")) {
                    this.setter.addValue(this.parseItem(item));
                }
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "ITEM,ITEM,...";
        }
    }

    public static final class BooleanOptionHandler
    extends OptionHandler<Boolean> {
        public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            boolean hasParam;
            boolean value;
            try {
                String nextArg = params.getParameter(0);
                if (nextArg.equalsIgnoreCase("true") || nextArg.equals("1")) {
                    value = true;
                    hasParam = true;
                } else if (nextArg.equalsIgnoreCase("false") || nextArg.equals("0")) {
                    value = false;
                    hasParam = true;
                } else {
                    value = true;
                    hasParam = false;
                }
            }
            catch (CmdLineException e) {
                value = true;
                hasParam = false;
            }
            this.setter.addValue((Object)value);
            return hasParam ? 1 : 0;
        }

        public String getDefaultMetaVariable() {
            return null;
        }
    }

    static interface Main {
        public void main() throws IOException, SoyCompilationException;
    }
}

