/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.SoyObjectType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.proto.FieldInterpreter;
import com.google.template.soy.types.proto.JavaQualifiedNames;
import com.google.template.soy.types.proto.JsQualifiedNameHelper;
import com.google.template.soy.types.proto.Protos;
import com.google.template.soy.types.proto.SafeStringTypes;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class SoyProtoTypeImpl
implements SoyObjectType,
SoyProtoType {
    private static final Logger logger = Logger.getLogger(SoyProtoTypeImpl.class.getName());
    private final SoyTypeRegistry typeRegistry;
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, Field> fields;

    public SoyProtoTypeImpl(SoyTypeRegistry typeRegistry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.typeRegistry = typeRegistry;
        this.typeDescriptor = descriptor;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (Protos.shouldJsIgnoreField(fieldDescriptor)) continue;
            NormalField normalField = new NormalField(fieldDescriptor);
            builder.put((Object)normalField.getName(), (Object)normalField);
        }
        HashMultimap extensionsBySoyName = HashMultimap.create();
        for (Descriptors.FieldDescriptor fieldDescriptor : extensions) {
            ExtensionField field = new ExtensionField(fieldDescriptor);
            extensionsBySoyName.put((Object)field.getName(), (Object)field);
        }
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)extensionsBySoyName).entrySet()) {
            String fieldName = (String)entry.getKey();
            Set ambiguousFields = (Set)entry.getValue();
            if (ambiguousFields.size() == 1) {
                builder.put((Object)fieldName, Iterables.getOnlyElement((Iterable)ambiguousFields));
                continue;
            }
            AmbiguousFieldSet value = new AmbiguousFieldSet(fieldName, ambiguousFields);
            logger.severe("Proto " + descriptor.getFullName() + " has multiple extensions with the name \"" + fieldName + "\": " + value.fullFieldNames + " this field will not be accessible from soy");
            builder.put((Object)fieldName, (Object)value);
        }
        this.fields = builder.build();
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.OBJECT;
    }

    @Override
    public boolean isAssignableFrom(SoyType fromType) {
        return fromType == this;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        return value instanceof Value && ((Value)value).getProto().getDescriptorForType() == this.typeDescriptor;
    }

    @Override
    public Class<? extends SoyValue> javaType() {
        return Value.class;
    }

    @Override
    public String getName() {
        return this.typeDescriptor.getFullName();
    }

    @Override
    public SoyType getFieldType(String fieldName) {
        Field field = (Field)this.fields.get((Object)fieldName);
        return field != null ? field.getType() : null;
    }

    @Override
    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return JsQualifiedNameHelper.getQualifiedName(this.typeDescriptor);
            }
            case TOFU: {
                return JavaQualifiedNames.getQualifiedName(this.typeDescriptor) + ".getDescriptor()";
            }
            case JBC_SRC: {
                return JavaQualifiedNames.getClassName(this.typeDescriptor);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFieldAccessExpr(String fieldContainerExpr, String fieldName, SoyBackendKind backend) {
        Field field = (Field)this.fields.get((Object)fieldName);
        return field != null ? field.getAccessExpr(fieldContainerExpr, backend) : null;
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        return ((Field)this.fields.get((Object)fieldName)).getDescriptor();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ImmutableSet<String> getFieldAccessImports(String fieldName, SoyBackendKind backend) {
        Field field = (Field)this.fields.get((Object)fieldName);
        if (field != null) {
            return field.getImportsForAccessExpr(backend);
        }
        return ImmutableSet.of();
    }

    @Override
    public String getDescriptorExpression() {
        Descriptors.Descriptor descriptor = this.typeDescriptor;
        while (descriptor.getContainingType() != null) {
            descriptor = descriptor.getContainingType();
        }
        return JavaQualifiedNames.getQualifiedName(descriptor) + ".getDescriptor()";
    }

    @Nullable
    Field getField(String name) {
        return (Field)this.fields.get((Object)name);
    }

    @Override
    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    private static String computeSoyName(Descriptors.FieldDescriptor field) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName()) + SoyProtoTypeImpl.fieldSuffix(field);
    }

    private static String fieldSuffix(Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            if (Protos.hasJsMapKey(field)) {
                return "Map";
            }
            return "List";
        }
        return "";
    }

    private static final class AmbiguousFieldSet
    implements Field {
        private final ImmutableSet<String> fullFieldNames;
        private final ImmutableSet<ExtensionField> extensions;
        private final String name;

        AmbiguousFieldSet(String name, Set<ExtensionField> fields) {
            this.name = name;
            Preconditions.checkArgument((fields.size() > 1 ? 1 : 0) != 0);
            this.extensions = ImmutableSet.copyOf(fields);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ExtensionField field : fields) {
                builder.add((Object)field.fieldDescriptor.getFullName());
            }
            this.fullFieldNames = builder.build();
        }

        @Override
        public boolean hasField(Message proto) {
            for (ExtensionField field : this.extensions) {
                if (!field.hasField(proto)) continue;
                return true;
            }
            return false;
        }

        @Override
        public SoyType getType() {
            throw this.failure();
        }

        @Override
        public Descriptors.FieldDescriptor getDescriptor() {
            throw this.failure();
        }

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Message owningMessage) {
            throw this.failure();
        }

        private RuntimeException failure() {
            return new IllegalStateException(String.format("Cannot access $%s. It may refer to any one of the following extensions, and Soy doesn't have enough information to decide which.\n%s\nTo resolve ensure that all extension fields accessed from soy have unique names.", this.name, this.fullFieldNames));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAccessExpr(String protoExpr, SoyBackendKind backendKind) {
            throw this.failure();
        }

        @Override
        public ImmutableSet<String> getImportsForAccessExpr(SoyBackendKind backend) {
            throw this.failure();
        }
    }

    private final class ExtensionField
    extends NormalField {
        ExtensionField(Descriptors.FieldDescriptor desc) {
            super(desc);
        }

        @Override
        public String getAccessExpr(String protoExpr, SoyBackendKind backendKind) {
            switch (backendKind) {
                case JS_SRC: {
                    return protoExpr + ".getExtension(" + this.getExtensionJsName() + ")";
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> getImportsForAccessExpr(SoyBackendKind backend) {
            ImmutableSet.Builder imports = ImmutableSet.builder().addAll(super.getImportsForAccessExpr(backend));
            switch (backend) {
                case JS_SRC: {
                    imports.add((Object)JsQualifiedNameHelper.getImportForExtension(this.fieldDescriptor));
                    break;
                }
                case TOFU: {
                    String extensionFieldName = JavaQualifiedNames.underscoresToCamelCase(this.fieldDescriptor.getName(), false);
                    String extensionFieldHolderClassName = this.fieldDescriptor.getExtensionScope() != null ? JavaQualifiedNames.getQualifiedName(this.fieldDescriptor.getExtensionScope()) : JavaQualifiedNames.getPackage(this.fieldDescriptor.getFile()) + "." + JavaQualifiedNames.getOuterClassname(this.fieldDescriptor.getFile());
                    imports.add((Object)(extensionFieldHolderClassName + "." + extensionFieldName + ".getDescriptor()"));
                    break;
                }
            }
            return imports.build();
        }

        private String getExtensionJsName() {
            return JsQualifiedNameHelper.getQualifiedExtensionName(this.fieldDescriptor);
        }
    }

    private class NormalField
    implements Field {
        protected final Descriptors.FieldDescriptor fieldDescriptor;
        protected final String name;
        @GuardedBy(value="this")
        private volatile FieldInterpreter interpreter;

        private NormalField(Descriptors.FieldDescriptor desc) {
            this.fieldDescriptor = desc;
            this.name = SoyProtoTypeImpl.computeSoyName(desc);
        }

        private NormalField(String name) {
            this.fieldDescriptor = null;
            this.name = name;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public SoyType getType() {
            return this.impl().type();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FieldInterpreter impl() {
            FieldInterpreter local = this.interpreter;
            if (local == null) {
                NormalField normalField = this;
                synchronized (normalField) {
                    local = this.interpreter;
                    if (local == null) {
                        this.interpreter = local = FieldInterpreter.create(SoyProtoTypeImpl.this.typeRegistry, this.fieldDescriptor);
                    }
                }
            }
            return local;
        }

        @Override
        public boolean hasField(Message proto) {
            return this.fieldDescriptor.isRepeated() || this.fieldDescriptor.hasDefaultValue() || proto.hasField(this.fieldDescriptor);
        }

        @Override
        public String getAccessExpr(String protoExpr, SoyBackendKind backendKind) {
            switch (backendKind) {
                case JS_SRC: {
                    String accessExpr = protoExpr + ".get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, this.name) + "()";
                    String valueConverterFnName = this.getValueConverterFnName(backendKind);
                    if (valueConverterFnName != null) {
                        accessExpr = valueConverterFnName + "(" + accessExpr + ")";
                    }
                    return accessExpr;
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableSet<String> getImportsForAccessExpr(SoyBackendKind backend) {
            String valueConverterFnName = this.getValueConverterFnName(backend);
            if (valueConverterFnName != null) {
                return ImmutableSet.of((Object)valueConverterFnName);
            }
            return ImmutableSet.of();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        private String getValueConverterFnName(SoyBackendKind backend) {
            switch (backend) {
                case JS_SRC: {
                    switch (this.fieldDescriptor.getJavaType()) {
                        case MESSAGE: {
                            String fieldTypeName = this.fieldDescriptor.getMessageType().getFullName();
                            SanitizedType valueConverterOutputType = (SanitizedType)SafeStringTypes.SAFE_STRING_PROTO_NAME_TO_SANITIZED_TYPE.get((Object)fieldTypeName);
                            if (valueConverterOutputType == null) return null;
                            return "soydata.unpackProtoToSanitized" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, valueConverterOutputType.getKind().name());
                        }
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public SoyValueProvider intepretField(SoyValueConverter converter, Message message) {
            return this.impl().intepretField(converter, message.getField(this.fieldDescriptor));
        }

        @Override
        public Descriptors.FieldDescriptor getDescriptor() {
            return this.fieldDescriptor;
        }
    }

    static interface Field {
        public String getName();

        public SoyType getType();

        public boolean hasField(Message var1);

        public String getAccessExpr(String var1, SoyBackendKind var2);

        public ImmutableSet<String> getImportsForAccessExpr(SoyBackendKind var1);

        public SoyValueProvider intepretField(SoyValueConverter var1, Message var2);

        public Descriptors.FieldDescriptor getDescriptor();
    }

    public static interface Value
    extends SoyRecord {
        public Message getProto();
    }
}

