/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.aggregate;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.types.SoyType;
import java.util.Objects;

public final class ListType
implements SoyType {
    public static final ListType EMPTY_LIST = new ListType(null);
    private final SoyType elementType;

    private ListType(SoyType elementType) {
        this.elementType = elementType;
    }

    public static ListType of(SoyType elementType) {
        Preconditions.checkNotNull((Object)elementType);
        return new ListType(elementType);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.LIST;
    }

    public SoyType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isAssignableFrom(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.LIST) {
            ListType srcListType = (ListType)srcType;
            if (srcListType == EMPTY_LIST) {
                return true;
            }
            if (this == EMPTY_LIST) {
                return false;
            }
            return this.elementType.isAssignableFrom(srcListType.elementType);
        }
        return false;
    }

    @Override
    public boolean isInstance(SoyValue value) {
        return value instanceof SoyList;
    }

    @Override
    public Class<? extends SoyValue> javaType() {
        return SoyList.class;
    }

    public String toString() {
        return "list<" + this.elementType + ">";
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && Objects.equals(((ListType)other).elementType, this.elementType);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.elementType);
    }
}

