/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.SoyNode;

public final class MsgPluralCaseNode
extends CaseOrDefaultNode
implements SoyNode.MsgBlockNode {
    private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS = SoyErrorKind.of("Plural cases must be nonnegative integers.");
    private static final SoyErrorKind MALFORMED_PLURAL_CASE = SoyErrorKind.of("Invalid number in ''plural case'' command text");
    private final int caseNumber;

    private MsgPluralCaseNode(int id, SourceLocation sourceLocation, String commandText, int caseNumber) {
        super(id, sourceLocation, "case", commandText);
        this.caseNumber = caseNumber;
    }

    private MsgPluralCaseNode(MsgPluralCaseNode orig, CopyState copyState) {
        super(orig, copyState);
        this.caseNumber = orig.caseNumber;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_CASE_NODE;
    }

    public int getCaseNumber() {
        return this.caseNumber;
    }

    @Override
    public MsgPluralCaseNode copy(CopyState copyState) {
        return new MsgPluralCaseNode(this, copyState);
    }

    public static final class Builder {
        public static final MsgPluralCaseNode ERROR = new MsgPluralCaseNode(-1, SourceLocation.UNKNOWN, "error", 1);
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgPluralCaseNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            int caseNumber = 0;
            try {
                caseNumber = Integer.parseInt(this.commandText);
                if (caseNumber < 0) {
                    errorReporter.report(this.sourceLocation, PLURAL_CASE_OUT_OF_BOUNDS, new Object[0]);
                }
            }
            catch (NumberFormatException nfe) {
                errorReporter.report(this.sourceLocation, MALFORMED_PLURAL_CASE, new Object[0]);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            MsgPluralCaseNode node = new MsgPluralCaseNode(this.id, this.sourceLocation, this.commandText, caseNumber);
            return node;
        }
    }
}

